# Configure path for the Genetic Data Analysis Library (GDL)
# Jean-Baptiste Veyrieras <veyrieras@moulon.inra.fr>, April 2006
# This script has been modified from the gsl.m4 written by
# Christopher R. Gabriel <cgabriel@linux.it>, April 2000 

AC_DEFUN([AM_PATH_GDL],
[
AC_ARG_WITH(gdl-prefix,[  --with-gdl-prefix=PFX   Prefix where GDL is installed (optional)],
            gdl_prefix="$withval", gdl_prefix="")
AC_ARG_WITH(gdl-exec-prefix,[  --with-gdl-exec-prefix=PFX Exec prefix where GDL is installed (optional)],
            gdl_exec_prefix="$withval", gdl_exec_prefix="")
AC_ARG_ENABLE(gdltest, [  --disable-gdltest       Do not try to compile and run a test GDL program],
		    , enable_gdltest=yes)

  if test "x${GDL_CONFIG+set}" != xset ; then
     if test "x$gdl_prefix" != x ; then
         GDL_CONFIG="$gdl_prefix/bin/gdl-config"
     fi
     if test "x$gdl_exec_prefix" != x ; then
        GDL_CONFIG="$gdl_exec_prefix/bin/gdl-config"
     fi
  fi

  AC_PATH_PROG(GDL_CONFIG, gdl-config, no)
  min_gdl_version=ifelse([$1], ,0.2.5,$1)
  AC_MSG_CHECKING(for GDL - version >= $min_gdl_version)
  no_gdl=""
  if test "$GDL_CONFIG" = "no" ; then
    no_gdl=yes
  else
    GDL_CFLAGS=`$GDL_CONFIG --cflags`
    GDL_LIBS=`$GDL_CONFIG --libs`

    gdl_major_version=`$GDL_CONFIG --version | \
           sed 's/^\([[0-9]]*\).*/\1/'`
    if test "x${gdl_major_version}" = "x" ; then
       gdl_major_version=0
    fi

    gdl_minor_version=`$GDL_CONFIG --version | \
           sed 's/^\([[0-9]]*\)\.\{0,1\}\([[0-9]]*\).*/\2/'`
    if test "x${gdl_minor_version}" = "x" ; then
       gdl_minor_version=0
    fi

    gdl_micro_version=`$GDL_CONFIG --version | \
           sed 's/^\([[0-9]]*\)\.\{0,1\}\([[0-9]]*\)\.\{0,1\}\([[0-9]]*\).*/\3/'`
    if test "x${gdl_micro_version}" = "x" ; then
       gdl_micro_version=0
    fi

    if test "x$enable_gdltest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $GDL_CFLAGS"
      LIBS="$LIBS $GDL_LIBS"

      rm -f conf.gdltest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char* my_strdup (const char *str);

char*
my_strdup (const char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = (char *)malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main (void)
{
  int major = 0, minor = 0, micro = 0;
  int n;
  char *tmp_version;

  system ("touch conf.gdltest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_gdl_version");

  n = sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) ;

  if (n != 2 && n != 3) {
     printf("%s, bad version string\n", "$min_gdl_version");
     exit(1);
   }

   if (($gdl_major_version > major) ||
      (($gdl_major_version == major) && ($gdl_minor_version > minor)) ||
      (($gdl_major_version == major) && ($gdl_minor_version == minor) && ($gdl_micro_version >= micro)))
    {
      exit(0);
    }
  else
    {
      printf("\n*** 'gdl-config --version' returned %d.%d.%d, but the minimum version\n", $gdl_major_version, $gdl_minor_version, $gdl_micro_version);
      printf("*** of GDL required is %d.%d.%d. If gdl-config is correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If gdl-config was wrong, set the environment variable GDL_CONFIG\n");
      printf("*** to point to the correct copy of gdl-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      exit(1);
    }
}

],, no_gdl=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_gdl" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$GDL_CONFIG" = "no" ; then
       echo "*** The gdl-config script installed by GDL could not be found"
       echo "*** If GDL was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the GDL_CONFIG environment variable to the"
       echo "*** full path to gdl-config."
     else
       if test -f conf.gdltest ; then
        :
       else
          echo "*** Could not run GDL test program, checking why..."
          CFLAGS="$CFLAGS $GDL_CFLAGS"
          LIBS="$LIBS $GDL_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding GDL or finding the wrong"
          echo "*** version of GDL. If it is not finding GDL, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means GDL was incorrectly installed"
          echo "*** or that you have moved GDL since it was installed. In the latter case, you"
          echo "*** may want to edit the gdl-config script: $GDL_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
#     GDL_CFLAGS=""
#     GDL_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(GDL_CFLAGS)
  AC_SUBST(GDL_LIBS)
  rm -f conf.gdltest
])


