/*  
 * 	gdl_common.h
 * 
 *  Brief description of the file
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 * 
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_COMMON_H__
#define __GDL_COMMON_H__ 

#ifdef __cplusplus
#  define __BEGIN_DECLS extern "C" {
#  define END_DECLS   }
#else /* !__cplusplus */
#  define __BEGIN_DECLS
#  define __END_DECLS
#endif /* __cplusplus */

#if HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <sys/types.h>

#if STDC_HEADERS
#  include <stdlib.h>
#  include <string.h>
#elif HAVE_STRINGS_H
#  include <strings.h>
#endif /*STDC_HEADERS*/

#if HAVE_LIMITS_H
#  include <limits.h>
#define GDL_CHAR_BIT CHAR_BIT
#else
#define GDL_CHAR_BIT 8
#endif

#if HAVE_UNISTD_H
#  include <unistd.h>
#endif

#if HAVE_STDARG_H
#  include <stdarg.h>
#  define VA_START(a, f)        va_start(a, f)
#else
#  if HAVE_VARARGS_H
#    include <varargs.h>
#    define VA_START(a, f)      va_start(a)
#  endif
#endif

#if HAVE_ERRNO_H
#  include <errno.h>
#endif /*HAVE_ERRNO_H*/
#ifndef errno
/* Some systems #define this! */
extern int errno;
#endif

#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS  0
#  define EXIT_FAILURE  1
#endif

#define GDL_CALLOC(type, num)                                  \
        ((type *) gdl_calloc ((num), sizeof(type)))
#define GDL_MALLOC(type, num)                                  \
        ((type *) gdl_malloc ((num) * sizeof(type)))
#define GDL_REALLOC(type, p, num)                              \
        ((type *) gdl_realloc ((p), (num) * sizeof(type)))
#define GDL_FREE(stale) \
        if (stale) { free (stale);  stale = 0; }
#define GDL_MATRIX_ALLOC(type, num1, num2) \
		((type **) gdl_malloc2D (sizeof(type*), sizeof(type), num1, num2))
#define GDL_MATRIX_FREE(stale, num) \
        if (stale) { size_t i; for( i = 0; i < num; i++) { free(stale[i]); } free(stale); }

// use config to get the maxline...
#define GDL_MAXLINE 1000

#include <gdl/gdl_types.h>
                                               
__BEGIN_DECLS

extern void *gdl_calloc    (const size_t num, const size_t size);
extern void *gdl_malloc    (const size_t num);
extern void *gdl_realloc   (void *p, const size_t num);
extern void **gdl_malloc2D (const size_t size1, const size_t size2, const size_t num1, const size_t num2);
extern void *gdl_array_grow (const size_t type, void * p, size_t * size, void * x);

typedef struct 
{
	void   (*free)    (void * data);
	void * (*clone)(const void * data);
	int    (*compare) (const void * data0, const void * data1);
    void * (*fread)   (FILE * stream);
    int    (*fwrite)  (FILE * stream, const void * data);
} gdl_data_interface;

typedef void (*gdl_data_free)(void * data);
typedef void * (*gdl_data_clone)(const void * data);
typedef int (*gdl_data_compare) (const void * data0, const void * data1);
typedef void * (*gdl_data_fread) (FILE * stream);
typedef int (*gdl_data_fwrite) (FILE * stream, const void * data);
typedef int  (*gdl_data_apply)  (const void * data, const void * user);

typedef enum
{
   gdl_false,
   gdl_true
} gdl_boolean;

typedef double  * gdl_double_ptr;
typedef int     * gdl_int_ptr;
typedef long    * gdl_long_ptr;
typedef char    * gdl_char_ptr;

GDL_VAR const gdl_data_interface * gdl_interface_long_double;
GDL_VAR const gdl_data_interface * gdl_interface_double;
GDL_VAR const gdl_data_interface * gdl_interface_float;
GDL_VAR const gdl_data_interface * gdl_interface_ulong;
GDL_VAR const gdl_data_interface * gdl_interface_long;
GDL_VAR const gdl_data_interface * gdl_interface_int;
GDL_VAR const gdl_data_interface * gdl_interface_uint;
GDL_VAR const gdl_data_interface * gdl_interface_ushort;
GDL_VAR const gdl_data_interface * gdl_interface_short;
GDL_VAR const gdl_data_interface * gdl_interface_uchar;
GDL_VAR const gdl_data_interface * gdl_interface_char;

__END_DECLS

#include <gdl/gdl_version.h>
#include <gdl/gdl_machine.h>

#endif /* __GDL_COMMON_H__ */
