/* gdl_precision.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Author:  B. Gough and G. Jungman */

#ifndef __GDL_PRECISION_H__
#define __GDL_PRECISION_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_types.h>

__BEGIN_DECLS


/* A type for the precision indicator.
 * This is mainly for pedagogy.
 */
typedef  unsigned int  gdl_prec_t;


/* The number of precision types.
 * Remember that precision-mode
 * can index an array.
 */
#define _GDL_PREC_T_NUM 3


/* Arrays containing derived
 * precision constants for the
 * different precision levels.
 */
GDL_VAR const double gdl_prec_eps[];
GDL_VAR const double gdl_prec_sqrt_eps[];
GDL_VAR const double gdl_prec_root3_eps[];
GDL_VAR const double gdl_prec_root4_eps[];
GDL_VAR const double gdl_prec_root5_eps[];
GDL_VAR const double gdl_prec_root6_eps[];


__END_DECLS

#endif /* __GDL_PRECISION_H__ */
