#ifndef __GDL_SYS_H__
#define __GDL_SYS_H__

#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS /* empty */
# define __END_DECLS /* empty */
#endif

__BEGIN_DECLS

int gdl_isnan (const double x);
int gdl_isinf (const double x);
int gdl_finite (const double x);

double gdl_nan (void);
double gdl_posinf (void);
double gdl_neginf (void);
double gdl_fdiv (const double x, const double y);

double gdl_coerce_double (const double x);
float gdl_coerce_float (const float x);
long double gdl_coerce_long_double (const long double x);

#define GDL_COERCE_DBL(x) (gdl_coerce_double(x))

__END_DECLS

#endif
