/*
 *  genex/gdl_genex_block.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_GENEX_BLOCK_H__
#define __GDL_GENEX_BLOCK_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_vector_uint.h>
#include <gdl/gdl_genex_probe.h>
#include <gdl/gdl_snp_annotation.h>
#include <gdl/gdl_snp.h>

__BEGIN_DECLS

typedef struct
{
	long start; // starting position on the chromosome
	long end;   // ending position on the chromosome
	unsigned char strand; // the strand of the gene block
	size_t size; // the number of probes inside the block
	gdl_genex_probe ** probes;
	size_t snp_up;
	size_t snp_down;
	size_t snp_start;
	size_t snp_end;
	double ** pval;
	size_t ** permut;
	unsigned char ignore;
	gdl_list ** record;
} gdl_genex_block;

gdl_genex_block * gdl_genex_block_alloc (const long start, const long end, const unsigned char strand);
void gdl_genex_block_free (gdl_genex_block * b);
gdl_genex_block * gdl_genex_block_clone (const gdl_genex_block * block);

void gdl_genex_block_add_probe (gdl_genex_block * b, gdl_genex_probe * probe);
void gdl_genex_block_rm_all_probe (gdl_genex_block * b);
void gdl_genex_block_init_permut_storage (gdl_genex_block * b);
void gdl_genex_block_set_obs_pval (gdl_genex_block * b, size_t probe, size_t snp, double pval);
double gdl_genex_block_get_obs_pval (gdl_genex_block * b, size_t probe, size_t snp);
void gdl_genex_block_set_permut_pval (gdl_genex_block * b, size_t probe, size_t snp, double pval);
double gdl_genex_block_get_permut_pval (gdl_genex_block * b, size_t probe, size_t snp, size_t size);
void gdl_genex_block_clean_permut_storage (gdl_genex_block * b);

void gdl_genex_block_record_snp (gdl_genex_block * b, const size_t probe, const size_t snp);
gdl_vector_uint * gdl_genex_block_get_record_snp (gdl_genex_block * block, const size_t probe);
void gdl_genex_block_clean_record_snp (gdl_genex_block * block);

void gdl_genex_annot_dico_add_count (const gdl_genex_block * b, const gdl_snp * snp, gdl_snp_annot_dico * dico);

gdl_genex_block * gdl_genex_block_fread (FILE * stream, gdl_genex_probe ** probes);
int gdl_genex_block_fwrite (FILE * stream, const gdl_genex_block * b);

__END_DECLS

#endif
