/*
 *  genex/gdl_genex_genome.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_GENEX_GENOME_H__
#define __GDL_GENEX_GENOME_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_genex_probe.h>
#include <gdl/gdl_genex_block.h>
#include <gdl/gdl_genex_gene.h>
#include <gdl/gdl_genex_chromosome.h>

__BEGIN_DECLS

typedef struct
{
	size_t nchrom;
	gdl_string      * dbdir;
	gdl_string    ** chroms;
} gdl_genex_genome;

gdl_genex_genome * gdl_genex_genome_alloc (const gdl_string * config_file, const gdl_string * probe_dir, const gdl_string * refseq_dir, const gdl_string * dbdir);
void gdl_genex_genome_free (gdl_genex_genome * v);
void gdl_genex_genome_rm (gdl_genex_genome * v);
size_t gdl_genex_genome_size (const gdl_genex_genome * g);
void gdl_genex_genome_select_most_variable_probe (gdl_genex_genome * v, size_t size);

gdl_genex_chromosome * gdl_genex_genome_get (const gdl_genex_genome * g, size_t i);
int gdl_genex_genome_set (const gdl_genex_genome * g, size_t i, gdl_genex_chromosome * c);
gdl_genex_genome * gdl_genex_genome_fread (FILE * stream);
int gdl_genex_genome_fwrite (FILE * stream, const gdl_genex_genome * v);


__END_DECLS

#endif
