/*
 *  genex/gdl_genex_probe.h 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_GENEX_PROBE_H__
#define __GDL_GENEX_PROBE_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>

__BEGIN_DECLS

typedef struct
{
	size_t idx;
	size_t size;
	long * start;
	long * end;
	unsigned char strand;
	gdl_string * name;
	double ** data;  // expr by pop
	double * mean;
	double * var;
	unsigned char ignore;
} gdl_genex_probe;

gdl_genex_probe * gdl_genex_probe_alloc (gdl_string * name, const unsigned char strand, long * start, long * end, const size_t nunit);
gdl_genex_probe * gdl_genex_meta_probe_alloc (gdl_genex_probe ** probes, const size_t nprobe, const size_t npop);
void gdl_genex_probe_free (gdl_genex_probe * b, const size_t npop);
gdl_genex_probe * gdl_genex_probe_clone (const gdl_genex_probe * probe);

double gdl_genex_probe_var_score (const gdl_genex_probe * p, const size_t * pop_sizes, const size_t npop);
size_t gdl_genex_probe_extreme_outlier (const gdl_genex_probe * p, const size_t * pop_sizes, const size_t npop);
void gdl_genex_probe_gaussian_quantile_normalize (gdl_genex_probe * p, const size_t * pop_sizes, const size_t npop);

gdl_genex_probe * gdl_genex_probe_fread (FILE * stream, const size_t npop, const size_t * pop_sizes);
int gdl_genex_probe_fwrite (FILE * stream, const gdl_genex_probe * p, const size_t npop, const size_t * pop_sizes); 

__END_DECLS

#endif
