/*  
 * 	entity/gdl_accession.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_ACCESSION_H__
#define __GDL_ACCESSION_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_entity.h>

__BEGIN_DECLS

typedef enum _gdl_accession_gmode  gdl_accession_gmode;

typedef gdl_entity gdl_accession;
typedef gdl_accession * gdl_accession_ptr;
typedef gdl_entity_mask gdl_accession_mask;

gdl_accession * gdl_accession_alloc (void);
gdl_accession * gdl_accession_new (const char * name);
void gdl_accession_free (gdl_accession * g);

size_t gdl_accession_size (gdl_accession * g);
gdl_boolean gdl_accession_is_phased (gdl_accession * g);

GDL_VAR const gdl_entity_type      * GDL_ACCESSION;

__END_DECLS

#endif /* __GDL_VIEW_ACCESSION_H__ */
