/*  
 *  entity/gdl_factor.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FACTOR_H__
#define __GDL_FACTOR_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_entity.h>
#include <gdl/gdl_factor_level.h>

__BEGIN_DECLS

typedef enum _gdl_factor_type gdl_factor_type;
typedef gdl_entity gdl_factor;
typedef gdl_factor * gdl_factor_ptr;

gdl_factor * gdl_factor_alloc (const gdl_factor_type * T);
gdl_factor * gdl_factor_new (const gdl_factor_type * T, const char * name);
void gdl_factor_free (gdl_factor * l);

const gdl_factor_type * gdl_factor_get_type (const gdl_factor * vl);

size_t gdl_factor_size (const gdl_factor * vl);
void gdl_factor_add (gdl_factor * vl, gdl_factor_level ** va, size_t owner);
gdl_factor_level * gdl_factor_get (const gdl_factor * vl, size_t idx);
gdl_factor_level * gdl_factor_search (const gdl_factor * vl, const gdl_string * name);

const gdl_factor_type * gdl_factor_type_fread (FILE * stream);
int gdl_factor_type_fwrite (FILE * stream, const gdl_factor_type * T);

GDL_VAR const gdl_entity_type * GDL_FACTOR;

GDL_VAR const gdl_factor_type * gdl_factor_categorial;
GDL_VAR const gdl_factor_type * gdl_factor_mixture;
GDL_VAR const gdl_factor_type * gdl_factor_continuous;

__END_DECLS

#endif /* __GDL_FACTOR_H__ */
