/*  
 * 	entity/gdl_genome.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GENOME_H__
#define __GDL_GENOME_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_entity.h>
#include <gdl/gdl_chromosome.h>

__BEGIN_DECLS

typedef gdl_entity gdl_genome;

gdl_genome * gdl_genome_alloc (void);
gdl_genome * gdl_genome_new (const char * name);
void gdl_genome_free (gdl_genome * g);

int gdl_genome_add (gdl_genome * g, gdl_chromosome * c);
size_t gdl_genome_size (const gdl_genome * g);
gdl_chromosome * gdl_genome_search (const gdl_genome * g, const char * name);
gdl_chromosome * gdl_genome_get (const gdl_genome * g, size_t i);

int gdl_genome_fprintf (FILE * stream, const gdl_genome * g);

GDL_VAR const gdl_entity_type * GDL_GENOME;

__END_DECLS

#endif /* __GDL_GENOME_H__ */
