/*  
 * 	entity/level.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_entity.h>
#include <gdl/gdl_factor_level.h>

gdl_factor_level *
gdl_factor_level_alloc (void)
{
	return gdl_entity_alloc (GDL_FACTOR_LEVEL);	
}

gdl_factor_level *
gdl_factor_level_new (const char * name)
{
	gdl_factor_level * a = gdl_entity_alloc (GDL_FACTOR_LEVEL);
	gdl_entity_set_name (a, name);
	return a;
}

void
gdl_factor_level_free (gdl_factor_level * va)
{
	gdl_entity_free (va);
}

static const gdl_entity_type _gdl_factor_level_type =
{
	0,
	"FL",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

const gdl_entity_type * GDL_FACTOR_LEVEL = &_gdl_factor_level_type;
