/* gglm/gdl_gglm.h
 * 
 * Copyright (C) 2006 Jean-Baptiste Veyrieras
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GDL_GGLM_H__
#define __GDL_GGLM_H__

#include <stdlib.h>
#include <gdl/gdl_common.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_fview_wrapper.h>
#include <gdl/gdl_gmatrix.h>
#include <gdl/gdl_multireg.h>

__BEGIN_DECLS

typedef struct _gdl_gglm_workspace gdl_gglm_workspace;
typedef struct _gdl_gglm_model gdl_gglm_model;
typedef enum _gdl_gglm_mode gdl_gglm_mode;

typedef struct
{
	size_t N;
	size_t M;
	size_t no;
	size_t nl;
	size_t trait;
 	size_t * other;
 	size_t * locus;
 	size_t df;
 	size_t df1;
 	double rsq;
 	double rsq1;
 	double fstat;
 	double pval;
 	gdl_vector * coeff;
 	gdl_vector * sd;
} gdl_gglm_static_model;

typedef struct 
{
	size_t N;
	size_t M;
	size_t df;
	size_t df1;
	double rsq;
	double rsq1;
	double log;
	double fstat;
	double pval;
	gdl_vector * c;
	gdl_vector * sd;
} gdl_gglm_model_result;

typedef struct
{
	const gdl_gmatrix_type * gcode;
	const gdl_gglm_mode    * mode;
	double fbpout;
	double fbpin;
	size_t fbiter;
	double pheap;
} gdl_gglm_parameter;

gdl_gglm_parameter * gdl_gglm_parameter_alloc (const gdl_gglm_mode * M, const gdl_gmatrix_type * T);

gdl_gglm_workspace * gdl_gglm_workspace_alloc (const gdl_fview_wrapper * t, const gdl_gview_wrapper * g, const gdl_fview_wrapper * o);
void gdl_gglm_workspace_free (gdl_gglm_workspace * w);
FILE * gdl_gglm_workspace_set_logger (gdl_gglm_workspace * w, FILE * stream);

int gdl_gglm_perform (gdl_gglm_workspace * w, gdl_gglm_parameter * params);
gdl_list * gdl_gglm_workspace_heap (const gdl_gglm_workspace * w);
const gdl_gmatrix_type  * gdl_gglm_workspace_gcode (const gdl_gglm_workspace * w);
const gdl_gview_wrapper * gdl_gglm_workspace_gdata (const gdl_gglm_workspace * w);
const gdl_fview_wrapper * gdl_gglm_workspace_tdata (const gdl_gglm_workspace * w);
const gdl_fview_wrapper * gdl_gglm_workspace_odata (const gdl_gglm_workspace * w);

gdl_gglm_model * gdl_gglm_model_alloc (const gdl_fview_wrapper * tdata, const gdl_fview_wrapper * odata, const gdl_gview_wrapper * gdata, const gdl_gmatrix_type  * gcode, size_t t);
size_t gdl_gglm_model_size (const gdl_gglm_model * m);
int gdl_gglm_model_add_eligible (gdl_gglm_model * m, const gdl_gview_wrapper * gdata, size_t g);
int gdl_gglm_model_discard_eligible (gdl_gglm_model * m);
int gdl_gglm_model_push_eligible (gdl_gglm_model * m);
int gdl_gglm_model_move_to_eligible (gdl_gglm_model * m, size_t g);
int gdl_gglm_model_push_back (gdl_gglm_model * m, size_t g);
int gdl_gglm_model_remove (gdl_gglm_model * m, size_t g);
const gdl_gglm_model_result * gdl_gglm_model_eval (gdl_gglm_model * m);

gdl_gglm_static_model * gdl_gglm_static_model_alloc (const gdl_gglm_model * m);
void gdl_gglm_static_model_free (gdl_gglm_static_model * sm);
gdl_gglm_static_model * gdl_gglm_static_model_fread (FILE * stream);
int gdl_gglm_static_model_fwrite (FILE * stream, const gdl_gglm_static_model * s);

int gdl_gglm_model_fprintf (FILE * stream, const gdl_gglm_model * m);

GDL_VAR const gdl_gglm_mode * gdl_gglm_test;
GDL_VAR const gdl_gglm_mode * gdl_gglm_forward_backward;

__END_DECLS

#endif
