/*  
 *  gmap/gdl_gmap.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GMAP_H__
#define __GDL_GMAP_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_locus.h>
#include <gdl/gdl_chromosome.h>
#include <gdl/gdl_genome.h>

__BEGIN_DECLS


typedef struct _gdl_gmap gdl_gmap;

gdl_gmap * gdl_gmap_alloc (void);
void gdl_gmap_free (gdl_gmap * g);
gdl_gmap * gdl_gmap_clone (const gdl_gmap * g);

gdl_gmap * gdl_gmap_fread (FILE * stream);
int gdl_gmap_fwrite (FILE * stream, const gdl_gmap * g);

int gdl_gmap_add (gdl_gmap * g, gdl_genome * genome);
size_t gdl_gmap_size (const gdl_gmap * gmap);
size_t gdl_gmap_genome_size (const gdl_gmap * gmap, size_t i);
size_t * gdl_gmap_genome_sizes (const gdl_gmap * g);
size_t gdl_gmap_chrom_number (const gdl_gmap * gmap);
size_t gdl_gmap_chromosome_size (const gdl_gmap * gmap, size_t i, size_t j);
gdl_genome * gdl_gmap_search (const gdl_gmap * g, const gdl_string * name);
gdl_genome * gdl_gmap_get (const gdl_gmap * g, size_t i);
gdl_chromosome * gdl_gmap_get_chromosome (const gdl_gmap * g, size_t i, size_t j);
gdl_locus * gdl_gmap_get_locus (const gdl_gmap * g, size_t i, size_t j, size_t l);
gdl_gdistance * gdl_gmap_get_distance (const gdl_gmap * g, size_t i, size_t j, size_t from, size_t to);

gdl_locus ** gdl_gmap_loci (const gdl_gmap * g, size_t * nl);
gdl_gmap * gdl_gmap_extract (const gdl_gmap * g, gdl_locus_ptr loci[], gdl_boolean ismap[], size_t nl, size_t owner);

gdl_gmap * gdl_gmap_fread (FILE * stream);
int gdl_gmap_fwrite (FILE * stream, const gdl_gmap * g);

typedef struct _gdl_gmap_interval_itr gdl_gmap_interval_itr;

gdl_gmap_interval_itr * gdl_gmap_interval_iterator (const gdl_gdistance * interval, const gdl_gdistance * step);
double gdl_gmap_interval_iterator_position (gdl_gmap_interval_itr * itr);
gdl_boolean gdl_gmap_interval_iterator_next (gdl_gmap_interval_itr * itr);
void gdl_gmap_interval_iterator_free (gdl_gmap_interval_itr * itr);

__END_DECLS

#endif /* __GDL_GMAP_H__ */
