/*  
 * 	gmap/gdl_gmap_writer.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GMAP_WRITER_H__
#define __GDL_GMAP_WRITER_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_gmap.h>

__BEGIN_DECLS

typedef struct _gdl_gmap_writer gdl_gmap_writer;

typedef struct 
{
	const char * name;
	int (*write)(gdl_gmap_writer * r, const gdl_gmap * gmap);
} gdl_gmap_writer_type;

struct _gdl_gmap_writer
{
	gdl_string * filename;
	gdl_string * error;
	FILE       * stream;
	const gdl_gmap_writer_type * type;	
};

gdl_gmap_writer * gdl_gmap_writer_alloc (const gdl_gmap_writer_type * type);
void gdl_gmap_writer_free (gdl_gmap_writer * writer);
int gdl_gmap_writer_open (gdl_gmap_writer * writer, const gdl_string * filename);
int gdl_gmap_writer_dump (gdl_gmap_writer * writer, const gdl_gmap * gmap);
int gdl_gmap_writer_close (gdl_gmap_writer * writer);
int gdl_gmap_writer_error (gdl_gmap_writer * writer, char * format, ...);

GDL_VAR const gdl_gmap_writer_type * gdl_gmap_writer_relative;
GDL_VAR const gdl_gmap_writer_type * gdl_gmap_writer_absolute;

__END_DECLS

#endif /* __GDL_GMAP_WRITER_H__ */
