/*  
 *  gmap/interval.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_locus.h>
#include <gdl/gdl_chromosome.h>
#include <gdl/gdl_genome.h>
#include <gdl/gdl_gmap.h>

struct _gdl_gmap_interval_itr
{
	double length;
	double step;
	double position;	
};

gdl_gmap_interval_itr *
gdl_gmap_interval_iterator (const gdl_gdistance * interval, const gdl_gdistance * step)
{
	gdl_gdistance * cstep;
	gdl_gmap_interval_itr * itr;
	
	itr = GDL_MALLOC (gdl_gmap_interval_itr, 1);
	
	itr->length   = interval->value;
	
	cstep = gdl_gdistance_convert (step, interval->type);
	
	if (!cstep || cstep->value >= interval->value)
	{
		GDL_FREE (cstep);
		GDL_FREE (itr);
		return NULL;
	}
	else
	{
		itr->step     = cstep->value;
		itr->position = itr->step;
		GDL_FREE (cstep);
	}
	
	return itr;
}

double
gdl_gmap_interval_iterator_position (gdl_gmap_interval_itr * itr)
{
	return itr->position;
}

gdl_boolean
gdl_gmap_interval_iterator_next (gdl_gmap_interval_itr * itr)
{
	itr->position += itr->step;
	
	if (itr->position>=itr->length)
	{
		return gdl_false;	
	}
	else
	{
		return gdl_true;	
	}
}

void
gdl_gmap_interval_iterator_free (gdl_gmap_interval_itr * itr)
{
	GDL_FREE (itr);
}
