/*  
 * 	gmap/reader.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_fsheet.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_gmap_reader.h>

gdl_gmap_reader *
gdl_gmap_reader_alloc (const gdl_gmap_reader_type * type)
{
	gdl_gmap_reader * r;
	
	r = GDL_CALLOC (gdl_gmap_reader, 1);
	r->type = type;
		
	return r;
}

void
gdl_gmap_reader_free (gdl_gmap_reader * reader)
{
	if (reader)
	{
		gdl_string_free (reader->filename);
		gdl_string_free (reader->error);
		GDL_FREE (reader);
	}
}

int
gdl_gmap_reader_open (gdl_gmap_reader * reader, 
                          const gdl_string * filename)
{
	if (reader && filename)
	{
		reader->stream = gdl_fileopen (filename, "r");
		if (reader->stream)
		{
			gdl_string_free (reader->filename);
			reader->filename = gdl_string_clone (filename);
			gdl_string_free (reader->error);
			reader->error = NULL;
			return GDL_SUCCESS;
		}
		else
			return GDL_EINVAL;
	}
	return GDL_EINVAL;
}

gdl_gmap *
gdl_gmap_reader_parse (gdl_gmap_reader * reader)
{
	if (reader==0)
	{
		return NULL;
	}
	else if ((reader->type->read)(reader) == GDL_SUCCESS)
	{
		return reader->gmap;
	}
	else
	{
		return NULL;
	}
}

int
gdl_gmap_reader_close (gdl_gmap_reader * reader)
{
	if (reader && reader->stream)
	{
		gdl_fileclose (reader->filename, reader->stream);
		return GDL_SUCCESS;
	}
	return GDL_EINVAL;
}

int
gdl_gmap_reader_error (gdl_gmap_reader * reader, const gdl_string * format, ...)
{
	if (reader == 0)
		return GDL_EINVAL;
	else
	{
		va_list ap; 
		
		va_start (ap, format);
		
		gdl_string_free (reader->error);
		
		reader->error = gdl_string_vsprintf (format, ap);
		
		va_end (ap);
		
		return GDL_SUCCESS;
	}
		
}
