/*  
 * 	gmatrix/permut.c
 *  
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_glabels.h>
#include <gdl/gdl_gmatrix.h>

static int 
gdl_gmatrix_shuffle_accession (gdl_gmatrix * m, const size_t locus, const gdl_rng * rng)
{ 
	const size_t n  = gdl_gmatrix_accession_size (m);
	const size_t s  = gdl_gmatrix_locus_first_column (m, locus);
	const size_t e  = s + gdl_gmatrix_locus_column_size (m, locus);
	size_t i,j,k;
	double x,y;
	
	for (i = n - 1; i > 0; i--)
	{
	   j = gdl_rng_uniform_int(rng, i+1);
	   // swap row i and j at locus
		for (k = s; k < e; k++)
		{
			x=gdl_gmatrix_get (m, i, k);
			y=gdl_gmatrix_get (m, j, k);
			gdl_gmatrix_set (m, j, k, x);
			gdl_gmatrix_set (m, i, k, y);
		}
 	}
 	
 	return GDL_SUCCESS;
}

int
gdl_gmatrix_permut_accession_by_locus (gdl_gmatrix * m, const gdl_rng * rng)
{
	const size_t nl = gdl_gmatrix_locus_size (m);
	size_t locus;
	
	for (locus=0;locus<nl;locus++)
	{
		gdl_gmatrix_shuffle_accession (m, locus, rng);
	}
	
	return GDL_SUCCESS;
}
