/*  
 * 	gpart/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:41 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>
#include <gdl/gdl_gview_reader.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_gpartition.h>

gdl_gview_reader_type *
_reader_type (size_t t)
{
	gdl_gview_reader_type * type =
    	gdl_gview_reader_type_new (gdl_gview_reader_standard);
    
    switch (t)
    {
    	case 1 :
    		gdl_gview_reader_type_missing (type, "missing");
    		gdl_gview_reader_type_locus_name (type, gdl_true);
    		return type;
    	case 2 :
		    gdl_gview_reader_type_missing (type, "0");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, " ");
		    gdl_gview_reader_type_ploidy (type, 2);
		    gdl_gview_reader_type_locus_name (type, gdl_false);
		    gdl_gview_reader_type_is_phased (type, gdl_false);
    		return type;
    	case 3 :
		    gdl_gview_reader_type_missing (type, "0");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, " ");
		    gdl_gview_reader_type_ploidy (type, 2);
		    gdl_gview_reader_type_locus_name (type, gdl_false);
		    gdl_gview_reader_type_is_phased (type, gdl_false);
    		return type;
    	case 4 :
    		gdl_gview_reader_type_missing (type, "N");
		    gdl_gview_reader_type_nfsep (type, " ");
		    gdl_gview_reader_type_gfsep (type, "");
		    gdl_gview_reader_type_ploidy (type, 1);
		    gdl_gview_reader_type_locus_name (type, gdl_true);
    		return type;
    }
}

gdl_gview *
_read_data (size_t t)
{
	size_t i, j;
	FILE * stream;
	gdl_string * file;
	gdl_gview_reader_type * type;
	gdl_gview_reader      * reader;
	gdl_gview * v;
	
	type = _reader_type (t);
	
	reader = gdl_gview_reader_alloc (type);
	
	file = gdl_string_sprintf ("examples/data%d.txt", t);
	
	gdl_gview_reader_open (reader, file);
	
	v = gdl_gview_reader_parse (reader);
	
	gdl_gview_reader_close (reader);
	
	gdl_gview_reader_free (reader);
	
	gdl_string_free (file);
	
	return v;	
}

static gdl_gpartition_state **
test_gpartition_fonction (const gdl_gview * g, const gdl_mask * m, size_t * ns, void * extra)
{
	size_t i;
	gdl_list * parts;
	gdl_list_itr * itr;
	gdl_gview_gmask_itr * gitr;
	gdl_gpartition_state ** states;
	
	parts = gdl_list_alloc (gdl_list_default);
	
	gitr = gdl_gview_gmask_iterator (g, m, gdl_gview_gmask_heterozygous, 4);
	
	do
	{
		gdl_list_push_back (parts, gdl_gview_gmask_iterator_value (gitr), 0);
	}
	while (gdl_gview_gmask_iterator_next (gitr));
	
	gdl_gview_gmask_iterator_free (gitr);
	
	states = GDL_MALLOC (gdl_gpartition_state *, gdl_list_size (parts));
	
	itr = gdl_list_iterator_front (parts);
	i = 0;
	do
	{
		states[i] = GDL_MALLOC (gdl_gpartition_state, 1);
		states[i]->mask = (gdl_mask *) gdl_list_iterator_value (itr);
		states[i]->data = gdl_hview_alloc (g, states[i]->mask);
		gdl_hview_create (states[i]->data);
		i++;
	}
	while (gdl_list_iterator_next (itr));
	
	gdl_list_iterator_free (itr);
	
	*ns = gdl_list_size (parts);
	
	gdl_list_free (parts);
	
	return states;	
}

static void
test_gpartition_state_free (void * data)
{
	gdl_hview * h = (gdl_hview *) data;
	gdl_hview_free (h);
}

static int
test_gligation_fonction (gdl_gpartition_state * cur, const gdl_gpartition_state * next, void * extra)
{
	gdl_hview * h1 = (gdl_hview *) cur->data;
	gdl_hview * h2 = (gdl_hview *) next->data;
	gdl_hview * kh1, * kh2;
	gdl_mask * m;
	
	kh1 = gdl_hview_kbest (h1, 50);
	printf ("BEST 1 %d\n", gdl_hview_haplotype_size (kh1));
	kh2 = gdl_hview_kbest (h2, 50);
	printf ("BEST 2 %d\n", gdl_hview_haplotype_size (kh2));
	
	fflush(stdout);
	
	m = gdl_hview_locus_ligation (kh1, kh2);

	gdl_hview_free (h1);
    gdl_mask_free (cur->mask);
	
    cur->mask = m;
    cur->data = kh1;
    
    printf ("LIGATION DONE %d\n", gdl_hview_haplotype_size (kh1));

    gdl_hview_free (kh2);
	
	return GDL_SUCCESS;
}

int
test_gpart ()
{
	int status;
	gdl_gpartition * gpart;
	gdl_mask * m, * u;
	gdl_gview * g;
	
	g = _read_data (2);
	
	u = gdl_gview_gmask_uninformative (g, NULL, GDL_LOCUS);
	
	m = gdl_gview_gmask_uninformative (g, u, GDL_ACCESSION);
	
	gdl_mask_free (u);
	
	gpart = gdl_gpartition_alloc (g, m);
	
	gdl_gpartition_init (gpart, &test_gpartition_fonction, NULL);
	
	do
	{
		status = gdl_gpartition_ligation (gpart,
		                         gdl_gligation_progressive,
		                         &test_gligation_fonction,
		                         &test_gpartition_state_free,
		                         NULL);
	} while (status == GDL_CONTINUE);
		
	gdl_gpartition_free (gpart, &test_gpartition_state_free);
	
	gdl_mask_free (m);
	
	gdl_gview_free (g);
}

int
main (void)
{
	do 
	{
		printf ("OK\n");
		test_gpart ();
	} while (0 == 0);
    exit (gdl_test_summary());
}
