/*  
 *  gpca/gdl_gpca_tag.h 
 *  
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:42 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#ifndef __GDL_GPCA_TAG_H__
#define __GDL_GPCA_TAG_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_gmatrix.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_pca.h>
#include <gdl/gdl_gpca.h>

__BEGIN_DECLS

typedef struct _gdl_gpca_tag_workspace gdl_gpca_tag_workspace;

gdl_gpca_tag_workspace * gdl_gpca_tag_workspace_alloc (const gdl_gpca_workspace_type * T, const gdl_gview_wrapper * gwrap);
void gdl_gpca_tag_workspace_free (gdl_gpca_tag_workspace * m);

FILE * gdl_gpca_tag_workspace_set_logger (gdl_gpca_tag_workspace * w, FILE * logger);

int gdl_gpca_tag_workspace_perform (gdl_gpca_tag_workspace * m, const double explained_variance, const double loading_threshold);

const gdl_gview * gdl_gpca_tag_workspace_data (const gdl_gpca_tag_workspace * m);
const gdl_gpca_workspace_type * gdl_gpca_tag_workspace_type (const gdl_gpca_tag_workspace * m);
const gdl_mask * gdl_gpca_tag_workspace_get (const gdl_gpca_tag_workspace * m);

const gdl_entity_type * gdl_gpca_tag_workspace_mode (const gdl_gpca_workspace_type * T);

__END_DECLS

#endif /* __GDL_GPCA_H__ */
