/*  
 *  gpoint/get.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_gpoint.h>

gdl_gvalues_get *
gdl_gvalues_get_alloc (size_t size)
{
	size_t i;
	gdl_gvalues_get * get;
	
	get       = GDL_MALLOC (gdl_gvalues_get, 1);
	get->size = size;
	get->x    = gdl_gvalues_alloc (size);
	
	for (i = 0; i < size; i++)
	{
		get->x->values[i] = gdl_gvalue_alloc ();
	}
		
	return get;
}


void
gdl_gvalues_get_free (gdl_gvalues_get * get)
{
	if (get)
	{
		size_t i;
		get->x->size = get->size;
		gdl_gvalues_free (get->x);
		GDL_FREE (get);
	}	
}

const gdl_gvalues *
gdl_gvalues_get_gvalues (gdl_gvalues_get * get)
{
	if (!get->na)
	{
		return get->x;
	}
	else
	{
		return NULL;
	}
}
