/*  
 * 	gpoint/grecin.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_gpoint.h>

gdl_gregistry_entry *
gdl_gregistry_entry_alloc (const gdl_gpoint_type * type, size_t size)
{
	gdl_gregistry_entry * e;
	
	e = GDL_MALLOC (gdl_gregistry_entry, 1);
	
	if (e == 0)
	{
		GDL_ERROR_VAL ("Unable to allocate memory in gdl_gregistry_entry_alloc",
		               GDL_ENOMEM,
		               0);
	}
	
	e->is_phased = gdl_false;
	e->type      = type;
	e->size      = size;
	e->values    = GDL_MALLOC (gdl_gvalues *, size);
	
	if (e->values == 0)
	{
		GDL_FREE (e);
		GDL_ERROR_VAL ("Unable to allocate memory in gdl_gregistry_entry_alloc",
		               GDL_ENOMEM,
		               0);
	}
	else
	{
		size_t i;
		
		for (i = 0; i < size; i++)
		{
			e->values[i] = NULL;
		}	
	}
	
	return e;	
}

void
gdl_gregistry_entry_free (gdl_gregistry_entry * e)
{
	if (e)
	{
		if (e->values != NULL)
		{
			size_t i;
			for (i = 0; i < e->size; i++)
			{
				gdl_gvalues_free (e->values[i]);
			}
			GDL_FREE (e->values);
		}
		GDL_FREE (e);	
	}	
}
