/*  
 * 	gpoint/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_gpoint.h>

void
test_alloc (void)
{
	gdl_gpoint  * g1, * g2, * g3, * g4, * g5;
	gdl_gregistry * gr
	  = gdl_gregistry_alloc (2);
	gdl_gregistry_entry * in 
	  = gdl_gregistry_entry_alloc (gdl_gpoint_haplo, 2);
	
	gdl_gvalues * v1 = gdl_gvalues_alloc (2);
	gdl_gvalues * v2 = gdl_gvalues_alloc (1);
	
	v1->values[0] = gdl_gvalue_alloc ();
	v1->values[1] = gdl_gvalue_alloc ();
	v2->values[0] = gdl_gvalue_alloc ();
	
	v1->values[0]->idx   = 1;
	v1->values[0]->value = 1.0;
	v1->values[1]->idx   = 1;
	v1->values[1]->value = 1.0;
	
	v2->values[0]->idx   = 2;
	v2->values[0]->value = 1.0;
	
	in->is_phased = 1;
	in->values[0] = v1;
	in->values[1] = v2;
	
	g1 = gdl_gregistry_add (gr, in);
	g2 = gdl_gregistry_add (gr, in);
	v1->values[0]->idx   = 2;
	g3 = gdl_gregistry_add (gr, in);
	v1->values[0]->idx   = 3;
	g4 = gdl_gregistry_add (gr, in);
	in->values[0] = NULL;
    g5 = gdl_gregistry_add (gr, in);
	in->values[0] = v1;
	g4 = gdl_gregistry_add (gr, in);
	v1->values[0]->idx = 1;
	g4 = gdl_gregistry_add (gr, in);
	gdl_gregistry_get (gr, g1);
    gdl_gregistry_get (gr, g2);
    gdl_gregistry_get (gr, g3);
    gdl_gregistry_get (gr, g4);
    gdl_gregistry_get (gr, g5);
    
	gdl_gvalues_free (v1);
    gdl_gvalues_free (v2);
    in->values[0] = NULL;
    in->values[1] = NULL;
	gdl_gregistry_entry_free (in);
	gdl_gregistry_free (gr);
}

gdl_gdatapoints *
_gdatapoints (void)
{

#define P 2
#define N 10
#define L 10	
	
	size_t i, j;
	gdl_gdatapoint * p 
	  = gdl_gdatapoint_alloc (gdl_gpoint_haplo, 2);
	gdl_gdatapoints * g 
	  = gdl_gdatapoints_alloc (P, N, L);
	gdl_gvalues * v1 = gdl_gvalues_alloc (1);
	gdl_gvalues * v2 = gdl_gvalues_alloc (1);
	gdl_gvalue * a1  = gdl_gvalue_alloc ();
	gdl_gvalue * a2  = gdl_gvalue_alloc ();
	
	v1->values[0] = a1;
	v2->values[0] = a2;
	
	p->values[0] = v1;
	p->values[1] = v2;
	p->is_phased = 1;
	
	for (i = 0; i < N; i++)
	{
		for (j = 0; j < L - 1; j++)
		{
			a1->idx   = i;
			a1->value = 1.0;
			a2->idx   = j;
			a2->value = 1.0;
			
			gdl_gdatapoints_set (g, i, j, p);
		}
	}
	
	gdl_gdatapoint_free (p);
	
	return g;	
}

void
test_fwrite (void)
{
	size_t status;
	FILE * stream;
	gdl_gdatapoints * g = _gdatapoints ();
	
	stream = gdl_fileopen ("test.dat", "w");
	
	status = gdl_gdatapoints_fwrite (stream, g);
	
	gdl_test (status != GDL_SUCCESS, "gdl_gdatapoints_fwrite returns valid status");
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_gdatapoints_free (g);
}

void
test_fread (void)
{
	size_t i,j,k,status;
	FILE * stream;
	gdl_gdatapoints * g;
	gdl_gdatapoint * p;
	
	stream = gdl_fileopen ("test.dat", "r");
	
	g = gdl_gdatapoints_fread (stream);
	
	gdl_test (g == NULL, "gdl_gdatapoints_fread returns valid pointer");
	
	gdl_fileclose ("test.dat", stream);
	
	status=0;
	
	for (i = 0; i < N; i++)
	{
		for (j = 0; j < L - 1; j++)
		{
			p = gdl_gdatapoints_get (g, i, j);
			
			if (p->type != gdl_gpoint_haplo)
			{
				status=1;
				break;
			}
			if (p->size != 2)
			{
				status=1;
				break;
			}
			if (p->values[0]->values[0]->idx != i)
			{
				status=1;
				break;
			}
			if (p->values[1]->values[0]->idx != j)
			{
				status=1;
				break;
			}
		}
		if (status)
			break;
			
		p =	gdl_gdatapoints_get (g, i, j);
		
		if (p != NULL)
		{
			status=1;
			break;	
		}
		
	}
	
	gdl_test (status != 0, "gdl_gdatapoints_fread returns correct gdatapoints");
		
	gdl_gdatapoints_free (g);
}

int
main (void)
{
	test_alloc ();
	test_fwrite ();
	test_fread ();
	exit (gdl_test_summary());
}
