/*  
 *  graphics/gdl_graphics_font.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 

#ifndef __GDL_GRAPHICS_H__
#define __GDL_GRAPHICS_H__

#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_graphics_font.h>
#include <gdl/gdl_graphics_rgb.h>
#include <gdl/gdl_graphics_transform.h>

__BEGIN_DECLS


typedef enum {
	  GDL_GRAPHICS_DEVICE_PS        = 0,
	  GDL_GRAPHICS_DEVICE_SVG       = 1
} gdl_graphics_device;

enum {
	GDL_GRAPHICS_STROKE_BASIC = 0,
	GDL_GRAPHICS_STROKE_DASH  = 1
};
/**
 * 
 * 
 */
typedef struct gdl_graphics2D {
	char *file;
	int device;
	int    stroke_ndash;
	double stroke_width;
	double *stroke_dashes;
	gdl_font      * font;
	gdl_rgb_color * color;
	gdl_rgb_color * paint;
	gdl_rgb_color * background;
	gdl_affine_transform *transform;
	gdl_affine_transform *_last_transform;
	FILE   *stream;
} gdl_graphics2D;

typedef struct gdl_graphics2D *gdl_graphics2D_ptr;

gdl_graphics2D_ptr gdl_graphics2D_alloc(void);
void gdl_graphics2D_free(gdl_graphics2D_ptr ptr);
gdl_graphics2D_ptr gdl_graphics2D_open(const char *file, double width, double height, int device);
void gdl_graphics2D_close(gdl_graphics2D_ptr, const char *file);
void gdl_graphics2D_set_stroke(gdl_graphics2D_ptr ptr, double width, int ndash, double *dasharray);
void gdl_graphics2D_set_color(gdl_graphics2D_ptr ptr, struct gdl_rgb_color *color);
void gdl_graphics2D_set_paint(gdl_graphics2D_ptr ptr, struct gdl_rgb_color *color);
void gdl_graphics2D_set_background(gdl_graphics2D_ptr ptr, struct gdl_rgb_color *color);
void gdl_graphics2D_set_transform(gdl_graphics2D_ptr ptr, struct gdl_affine_transform *transform);
struct gdl_rgb_color * gdl_graphics2D_get_color(gdl_graphics2D_ptr ptr);
struct gdl_affine_transform *gdl_graphics2D_get_transform(gdl_graphics2D_ptr ptr);
void gdl_graphics2D_add_transform(gdl_graphics2D_ptr ptr, struct gdl_affine_transform *transform);
void gdl_graphics2D_transform(gdl_graphics2D_ptr ptr, double x, double y, double *tx, double *ty);
void gdl_graphics2D_set_font(gdl_graphics2D_ptr ptr, struct gdl_font *font);
struct gdl_font *gdl_graphics2D_get_font(gdl_graphics2D_ptr ptr);
// Util
char *gdl_graphics2D_get_strpath2D(double *x, double *y, int np, int *len);
// Postscript
void gdl_graphics2D_start_ps(gdl_graphics2D_ptr g, double width, double height);
void gdl_graphics2D_end_ps(gdl_graphics2D_ptr g);
// SVG
void gdl_graphics2D_start_svg(gdl_graphics2D_ptr g, double width, double height);
void gdl_graphics2D_end_svg(gdl_graphics2D_ptr g);

/**
 * Primitive shapes
 */
void gdl_graphics2D_draw_line(gdl_graphics2D_ptr graph, double x1, double y1, double x2, double y2);
void gdl_graphics2D_draw_rect(gdl_graphics2D_ptr graph, double x, double y, double width, double height);
void gdl_graphics2D_fill_rect(gdl_graphics2D_ptr graph, double x, double y, double width, double height);
void gdl_graphics2D_draw_circle(gdl_graphics2D_ptr graph, double x, double y, double r);
void gdl_graphics2D_fill_circle(gdl_graphics2D_ptr graph, double x, double y, double r);
void gdl_graphics2D_draw_path(gdl_graphics2D_ptr graph, double *x, double *y, int np, int close);
void gdl_graphics2D_fill_path(gdl_graphics2D_ptr graph, double *x, double *y, int np);
void gdl_graphics2D_draw_text(gdl_graphics2D_ptr graph, double x, double y, const char *text);
// Postscript
void gdl_graphics2D_draw_line_ps(gdl_graphics2D_ptr graph, double x1, double y1, double x2, double y2);
void gdl_graphics2D_draw_rect_ps(gdl_graphics2D_ptr graph, double x, double y, double width, double height);
void gdl_graphics2D_fill_rect_ps(gdl_graphics2D_ptr graph, double x, double y, double width, double height);
void gdl_graphics2D_draw_circle_ps(gdl_graphics2D_ptr graph, double x, double y, double r);
void gdl_graphics2D_fill_circle_ps(gdl_graphics2D_ptr graph, double x, double y, double r); 
void gdl_graphics2D_draw_path_ps(gdl_graphics2D_ptr graph, double *x, double *y, int np, int close);
void gdl_graphics2D_fill_path_ps(gdl_graphics2D_ptr graph, double *x, double *y, int np);
void gdl_graphics2D_draw_text_ps(gdl_graphics2D_ptr graph, double x, double y, const char *text);
// SVG
void gdl_graphics2D_draw_line_svg(gdl_graphics2D_ptr graph, double x1, double y1, double x2, double y2);
void gdl_graphics2D_draw_rect_svg(gdl_graphics2D_ptr graph, double x, double y, double width, double height);
void gdl_graphics2D_fill_rect_svg(gdl_graphics2D_ptr graph, double x, double y, double width, double height);
void gdl_graphics2D_draw_circle_svg(gdl_graphics2D_ptr graph, double x, double y, double r);
void gdl_graphics2D_fill_circle_svg(gdl_graphics2D_ptr graph, double x, double y, double r); 
void gdl_graphics2D_draw_path_svg(gdl_graphics2D_ptr graph, double *x, double *y, int np, int close);
void gdl_graphics2D_fill_path_svg(gdl_graphics2D_ptr graph, double *x, double *y, int np);
void gdl_graphics2D_draw_text_svg(gdl_graphics2D_ptr graph, double x, double y, const char *text);

__END_DECLS

#endif
