/*  
 *  graphics/gdl_graphics_font.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GRAPHICS_FONT_H__
#define __GDL_GRAPHICS_FONT_H__

#include <stdio.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>

__BEGIN_DECLS

typedef enum {
	GDL_FONT_PLAIN    = 0,
	GDL_FONT_ITALIC   = 1,
	GDL_FONT_BOLD     = 2
} gdl_font_style;

typedef struct gdl_font {
	gdl_font_style style;
	int size;
	char *name;
	char *family;
} gdl_font;

typedef gdl_font * gdl_font_ptr;

gdl_font_ptr gdl_font_alloc (void);
void gdl_font_free (gdl_font_ptr ptr);
gdl_font * gdl_font_default(void);
void gdl_font_copy (gdl_font_ptr dest, gdl_font_ptr src);
int gdl_font_fprintf (FILE * stream, const gdl_font * font);
gdl_font * gdl_font_fscanf (FILE * stream);

__END_DECLS

#endif
