/*  
 * 	gview/gdl_gview_reader.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GVIEW_READER_H__
#define __GDL_GVIEW_READER_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_gview.h>

__BEGIN_DECLS

typedef struct _gdl_gview_reader gdl_gview_reader;
typedef struct _gdl_gview_reader_cell gdl_gview_reader_cell;

typedef struct 
{
	char * missing;
	char * recessive;
	char * gfsep;
	char * nfsep;
	char * psep;
	char * vsep;
	char * gsep;
	size_t ploidy;
	gdl_boolean has_acc_name;
	gdl_boolean has_loc_name;
	gdl_boolean is_phased;
	int (*read)(gdl_gview_reader * r);
	gdl_gview_reader_cell * (*cell)(gdl_gview_reader * r, const gdl_string * cell);
} gdl_gview_reader_type;

gdl_gview_reader_type * gdl_gview_reader_type_new (const gdl_gview_reader_type * type);
void gdl_gview_reader_type_free (gdl_gview_reader_type * type);
void gdl_gview_reader_type_missing (gdl_gview_reader_type * t, gdl_string * missing);
void gdl_gview_reader_type_recessive (gdl_gview_reader_type * t, gdl_string * recessive);
void gdl_gview_reader_type_data_separator (gdl_gview_reader_type * t, gdl_string * sep);
void gdl_gview_reader_type_name_separator (gdl_gview_reader_type * t, gdl_string * sep);
void gdl_gview_reader_type_phase_separator (gdl_gview_reader_type * t, gdl_string * sep);
void gdl_gview_reader_type_value_separator (gdl_gview_reader_type * t, gdl_string * sep);
void gdl_gview_reader_type_genotype_separator (gdl_gview_reader_type * t, gdl_string * sep);
void gdl_gview_reader_type_ploidy (gdl_gview_reader_type * t, size_t p);
void gdl_gview_reader_type_accession_name (gdl_gview_reader_type * type, gdl_boolean has);
void gdl_gview_reader_type_locus_name (gdl_gview_reader_type * t, gdl_boolean has);
void gdl_gview_reader_type_is_phased (gdl_gview_reader_type * t, gdl_boolean is);

typedef struct
{
   size_t n;	
   size_t idx;
   size_t * recessives;
   double value;
   char ** alleles;   	
} gdl_gview_reader_gpoint;

gdl_gview_reader_gpoint * gdl_gview_reader_gpoint_alloc (size_t n);

struct _gdl_gview_reader_cell
{
	size_t size;
	size_t is_phased;
	const gdl_gpoint_type * type;
	gdl_list              ** units;
	gdl_gdatapoint        * point;
};

gdl_gview_reader_cell * gdl_gview_reader_cell_alloc (const gdl_gpoint_type * type, size_t size);
void gdl_gview_reader_cell_free (gdl_gview_reader_cell * r);
gdl_gdatapoint * gdl_gview_reader_cell_gdatapoint (gdl_gview_reader_cell * cell);

typedef struct _gdl_gview_reader_cells gdl_gview_reader_cells;

gdl_gview_reader_cells * gdl_gview_reader_cells_alloc ();
void gdl_gview_reader_cells_free (gdl_gview_reader_cells * cells);
gdl_gview_reader_cell * gdl_gview_reader_cells_lookup (gdl_gview_reader_cells * cells, const gdl_string * string);
size_t gdl_gview_reader_cells_add (gdl_gview_reader_cells * cells, const gdl_string * string, gdl_gview_reader_cell * cell);

struct _gdl_gview_reader
{
	gdl_string * filename;
	gdl_string * error;
	FILE       * stream;
	gdl_gview_reader_type * type;
	gdl_gview * gview;
};

// High level api
gdl_gview_reader * gdl_gview_reader_alloc (gdl_gview_reader_type * type);
void gdl_gview_reader_free (gdl_gview_reader * reader);
int gdl_gview_reader_open (gdl_gview_reader * reader, const gdl_string * filename);
gdl_gview * gdl_gview_reader_parse (gdl_gview_reader * reader);
int gdl_gview_reader_close (gdl_gview_reader * reader);
int gdl_gview_reader_error (gdl_gview_reader * reader, char * format, ...);
// Low level api
gdl_gview_reader_cell * gdl_gview_reader_parse_cell (gdl_gview_reader * reader, const gdl_string * cell);
gdl_locus * gdl_gview_reader_add_locus (gdl_gview_reader * reader, char * name, size_t idx);
gdl_accession * gdl_gview_reader_add_accession (gdl_gview_reader * reader, char * name, size_t idx);
int gdl_gview_reader_update_locus (gdl_locus * locus, gdl_gview_reader_cell * cell);
int gdl_gview_reader_set_gdatapoint (gdl_gview_reader * reader, gdl_accession * va, gdl_locus * vl, gdl_gview_reader_cell * cell);

GDL_VAR const gdl_gview_reader_type * gdl_gview_reader_standard;
//GDL_VAR const gdl_gview_reader_type * gdl_gview_reader_frequence;

__END_DECLS

#endif /* __GDL_GVIEW_READER_H__ */
