/*  
 * 	gview/gdl_gview_wrapper.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_GVIEW_WRAPPER_H__
#define __GDL_GVIEW_WRAPPER_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_allele_block.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>
#include <gdl/gdl_gview_collector.h>

__BEGIN_DECLS

typedef struct _gdl_gview_wrapper_type gdl_gview_wrapper_type;
typedef struct _gdl_gview_wrapper gdl_gview_wrapper;
typedef struct _gdl_gview_wrapper_missing gdl_gview_wrapper_missing;

gdl_gview_wrapper * gdl_gview_wrapper_alloc (const gdl_gview_wrapper_type * T, const gdl_gview * gview, const gdl_mask * gmask);
void gdl_gview_wrapper_free (gdl_gview_wrapper * gw);

const gdl_gview * gdl_gview_wrapper_gview (const gdl_gview_wrapper * gw);
const gdl_mask * gdl_gview_wrapper_gmask (const gdl_gview_wrapper * gw);
const gdl_clustering * gdl_gview_wrapper_clustering (const gdl_gview_wrapper * gw);
gdl_gview_collector * gdl_gview_wrapper_missing_sites (const gdl_gview_wrapper * gw);
gdl_mask * gdl_gview_wrapper_gmask_c (const gdl_gview_wrapper * gw);
void gdl_gview_wrapper_set_missing_sites (gdl_gview_wrapper * gw, const gdl_gview_collector * missing);

size_t gdl_gview_wrapper_ploidy (const gdl_gview_wrapper * gw);
size_t gdl_gview_wrapper_accession_size (const gdl_gview_wrapper * gw);
size_t gdl_gview_wrapper_accession_size_c (const gdl_gview_wrapper * gw);
size_t gdl_gview_wrapper_locus_size (const gdl_gview_wrapper * gw);
size_t gdl_gview_wrapper_locus_allele_size (const gdl_gview_wrapper * gw, size_t i);
size_t gdl_gview_wrapper_accession_mult_c (const gdl_gview_wrapper * gw, size_t i);
size_t gdl_gview_wrapper_accession_idx_c (const gdl_gview_wrapper * gw, size_t i);
size_t gdl_gview_wrapper_accession_cidx_c (const gdl_gview_wrapper * gw, size_t i);

gdl_accession * gdl_gview_wrapper_get_accession (const gdl_gview_wrapper * gw, size_t i);
gdl_accession * gdl_gview_wrapper_get_accession_c (const gdl_gview_wrapper * gw, size_t ic);
gdl_locus     * gdl_gview_wrapper_get_locus (const gdl_gview_wrapper * gw, size_t i);
gdl_accession * gdl_gview_wrapper_search_accession (const gdl_gview_wrapper * gw, const gdl_string * name);
gdl_locus     * gdl_gview_wrapper_search_locus (const gdl_gview_wrapper * gw, const gdl_string * name);


gdl_gvalues_get * gdl_gview_wrapper_get_new (const gdl_gview_wrapper * gw);

int gdl_gview_wrapper_get_genotype (const gdl_gview_wrapper * gw, size_t i, size_t j, gdl_gvalues_get * g);
int gdl_gview_wrapper_get_allele (const gdl_gview_wrapper * gw, size_t i, size_t j, size_t k, gdl_gvalues_get * g);
gdl_boolean gdl_gview_wrapper_is_homozygous (const gdl_gview_wrapper * gw, size_t i, size_t j);
gdl_boolean gdl_gview_wrapper_has_missing (const gdl_gview_wrapper * gw, size_t i, size_t j);
gdl_boolean gdl_gview_wrapper_is_missing (const gdl_gview_wrapper * gw, size_t i, size_t j, size_t p);

int gdl_gview_wrapper_get_genotype_c (const gdl_gview_wrapper * gw, size_t i, size_t j, gdl_gvalues_get * g);
int gdl_gview_wrapper_get_allele_c (const gdl_gview_wrapper * gw, size_t i, size_t j, size_t k, gdl_gvalues_get * g);

gdl_vector * gdl_gview_wrapper_genotype_freq (const gdl_gview_wrapper * gw, size_t l, gdl_gvalues_get * g);
gdl_vector * gdl_gview_wrapper_allele_freq (const gdl_gview_wrapper * gw, size_t l, gdl_gvalues_get * g);

size_t gdl_gview_wrapper_missing_size (const gdl_gview_wrapper * gw);
size_t gdl_gview_wrapper_missing_accession_size (const gdl_gview_wrapper * gw);
size_t gdl_gview_wrapper_missing_glocus_size (const gdl_gview_wrapper * gw, size_t r);
size_t gdl_gview_wrapper_missing_hlocus_size (const gdl_gview_wrapper * gw, size_t r, size_t h);
size_t gdl_gview_wrapper_missing_accession_idx_c (const gdl_gview_wrapper * gw, size_t r);
const size_t * gdl_gview_wrapper_missing_glocus_idx (const gdl_gview_wrapper * gw, size_t r);
const size_t * gdl_gview_wrapper_missing_hlocus_idx (const gdl_gview_wrapper * gw, size_t r, size_t h);
gdl_gvalues * gdl_gview_wrapper_missing_gget (const gdl_gview_wrapper * gw, size_t r, size_t l);
gdl_gvalues * gdl_gview_wrapper_missing_hget (const gdl_gview_wrapper * gw, size_t r, size_t h, size_t l);
gdl_gvalues * gdl_gview_wrapper_missing_gget_c (const gdl_gview_wrapper * gw, size_t ridx, size_t lidx);
gdl_gvalues * gdl_gview_wrapper_missing_hget_c (const gdl_gview_wrapper * gw, size_t ridx, size_t lidx, size_t h);
void gdl_gview_wrapper_missing_greset (gdl_gview_wrapper * gw, size_t r, size_t l);
void gdl_gview_wrapper_missing_hreset (gdl_gview_wrapper * gw, size_t r, size_t h, size_t l);
void gdl_gview_wrapper_missing_greset_c (gdl_gview_wrapper * gw, size_t ridx, size_t lidx);
void gdl_gview_wrapper_missing_hreset_c (gdl_gview_wrapper * gw, size_t ridx, size_t lidx, size_t h);

gdl_allele_block * gdl_gview_wrapper_allele_block (const gdl_gview_wrapper * gw, const size_t ambiguous);
gdl_allele_block * gdl_gview_wrapper_allele_block_c (const gdl_gview_wrapper * gw, const size_t ambiguous);

void gld_gview_wrapper_window_imputation (gdl_gview_wrapper * gw, const size_t window_size, const gdl_rng * rng);

GDL_VAR const gdl_gview_wrapper_type * gdl_gview_wrapper_local;
GDL_VAR const gdl_gview_wrapper_type * gdl_gview_wrapper_global;

__END_DECLS

#endif
