/*  
 * 	gview/map.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>

gdl_gmap *
gdl_gview_extract_gmap (const gdl_gview * g, const gdl_mask * m, const gdl_gmap * map)
{
	size_t i, nl;
	gdl_locus ** loci;
	gdl_boolean * ismap;
	gdl_gmap * em;
	
	nl    = GDL_GVIEW_LOCUS_SIZE (g, m);
	ismap = GDL_CALLOC (gdl_boolean, nl);
	loci  = GDL_MALLOC (gdl_locus * , nl);
	
	for (i = 0; i < nl; i++)
	{
		loci[i] = GDL_GVIEW_GET_LOCUS (g, m, i);
	}
	
	em  = gdl_gmap_extract (map, loci, ismap, nl, 0);
	
	GDL_FREE (ismap);
	
	return em;
}

gdl_gmap *
gdl_gview_extract_gmap_clone (const gdl_gview * g, const gdl_mask * m, const gdl_gmap * map)
{
	size_t i, nl;
	gdl_locus ** loci;
	gdl_boolean * ismap;
	gdl_gmap * em;
	
	nl    = GDL_GVIEW_LOCUS_SIZE (g, m);
	ismap = GDL_CALLOC (gdl_boolean, nl);
	loci  = GDL_MALLOC (gdl_locus * , nl);
	
	for (i = 0; i < nl; i++)
	{
		loci[i] = gdl_entity_clone (GDL_GVIEW_GET_LOCUS (g, m, i));
	}
	
	em = gdl_gmap_extract (map, loci, ismap, nl, 1);
	
	GDL_FREE (ismap);
	
	return em;
}
