/*  
 * 	gview/mask_itr.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>

struct _gdl_gview_gmask_itr
{
	size_t current;
	size_t smax;
	const gdl_gview_gmask_type * type;
	const gdl_gview * g;
	const gdl_mask * m;
	gdl_mask * sm;
};

gdl_gview_gmask_itr *
gdl_gview_gmask_iterator (const gdl_gview * g, const gdl_mask * m, const gdl_gview_gmask_type * type, size_t smax)
{
	gdl_gview_gmask_itr * i;
	
	i = GDL_MALLOC (gdl_gview_gmask_itr, 1);
	
	i->g       = g;
	i->m       = m;
	i->type    = type;
	i->current = 0;
	i->smax    = smax;
	
	i->sm = (i->type->next)(i->g, i->m, &(i->current), i->smax);
	
	return i;
}

int
gdl_gview_gmask_iterator_next (gdl_gview_gmask_itr * itr)
{
	itr->sm = (itr->type->next)(itr->g, itr->m, &(itr->current), itr->smax);
	return (itr->sm) ? 1 : 0;
}

gdl_mask *
gdl_gview_gmask_iterator_value(gdl_gview_gmask_itr * itr)
{
	return itr->sm;
}

void
gdl_gview_gmask_iterator_free (gdl_gview_gmask_itr * itr)
{
	if (itr)
	{
		GDL_FREE (itr);	
	}		
}

static gdl_mask *
gdl_gview_gmask_heterozygous_next (const gdl_gview * g, 
                                     const gdl_mask * m,
                                     size_t * l,
                                     size_t smax)
{
	size_t i, j, na, nl, nh=0;
	gdl_locus * locus;
	gdl_entity_mask * hl;
	gdl_mask * sm;
	
	nl = GDL_GVIEW_LOCUS_SIZE (g, m);
	na = GDL_GVIEW_ACCESSION_SIZE (g, m);
	
	if (*l >= nl)
	{
		 return NULL;
	}
	
	hl = gdl_entity_mask_new (smax);
	
	for (j = *l; j < nl; j++)
	{
		locus = GDL_GVIEW_GET_LOCUS (g, m, j);
		for (i = 0; i < na; i++)
		{
			if (!GDL_GVIEW_IS_HOMOZYGOUS (g, m, i, j))
			{
				break;	
			}	
		}
		if (i < na)
		{
			nh++;
		}
		if (nh <= smax)
		{
			gdl_entity_mask_add (hl, locus);
		}
		else
		{
			break;	
		}
	}
	
	*l = j;
	
	sm = gdl_mask_alloc ();
	gdl_mask_set (sm, GDL_LOCUS, hl, 1);
	gdl_mask_set (sm, GDL_ACCESSION, gdl_mask_get_clone (m, GDL_ACCESSION), 1);
	
	return sm;
}

static const gdl_gview_gmask_type _hetero =
{
	"gdl_gview_gmask_heterozygous",
	&gdl_gview_gmask_heterozygous_next
};

const gdl_gview_gmask_type * gdl_gview_gmask_heterozygous = &_hetero;
