/*  
 * 	gview/rtype.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gview_reader.h>

gdl_gview_reader_type *
gdl_gview_reader_type_new (const gdl_gview_reader_type * type)
{
	if (type)
	{
		gdl_gview_reader_type * clone;
		
		clone = GDL_CALLOC (gdl_gview_reader_type, 1);
		
		clone->missing   = gdl_string_clone (type->missing);
		clone->recessive = gdl_string_clone (type->recessive);
		clone->gfsep     = gdl_string_clone (type->gfsep);
		clone->nfsep     = gdl_string_clone (type->nfsep);
		clone->psep      = gdl_string_clone (type->psep);
		clone->vsep      = gdl_string_clone (type->vsep);
		clone->gsep      = gdl_string_clone (type->gsep);
		clone->ploidy    = type->ploidy;
		clone->has_acc_name = type->has_acc_name;
		clone->has_loc_name = type->has_loc_name;
		clone->is_phased = type->is_phased;
		clone->read    = type->read;
		clone->cell    = type->cell;
		
		return clone;
	}
}

void
gdl_gview_reader_type_free (gdl_gview_reader_type * type)
{
	if (type)
	{
		gdl_string_free (type->missing);
		gdl_string_free (type->recessive);
		gdl_string_free (type->gfsep);
		gdl_string_free (type->nfsep);
		gdl_string_free (type->psep);
		gdl_string_free (type->vsep);
		gdl_string_free (type->gsep);
		GDL_FREE (type);
	}
}

void
gdl_gview_reader_type_missing (gdl_gview_reader_type * type, gdl_string * missing)
{
	gdl_string_free (type->missing);
	type->missing = gdl_string_clone (missing);
}

void
gdl_gview_reader_type_recessive (gdl_gview_reader_type * type, gdl_string * recessive)
{
	gdl_string_free (type->recessive);
	type->recessive = gdl_string_clone (recessive);
}

void
gdl_gview_reader_type_name_separator (gdl_gview_reader_type * type, gdl_string * nfsep)
{
	gdl_string_free (type->nfsep);
	type->nfsep = gdl_string_clone (nfsep);
}

void
gdl_gview_reader_type_data_separator (gdl_gview_reader_type * type, gdl_string * gfsep)
{
	gdl_string_free (type->gfsep);
	type->gfsep = gdl_string_clone (gfsep);	
}

void
gdl_gview_reader_type_phase_separator (gdl_gview_reader_type * type, gdl_string * sep)
{
	gdl_string_free (type->psep);
	type->psep = gdl_string_clone (sep);	
}

void
gdl_gview_reader_type_value_separator (gdl_gview_reader_type * type, gdl_string * sep)
{
	gdl_string_free (type->vsep);
	type->vsep = gdl_string_clone (sep);	
}

void
gdl_gview_reader_type_genotype_separator (gdl_gview_reader_type * type, gdl_string * sep)
{
	gdl_string_free (type->gsep);
	type->gsep = gdl_string_clone (sep);	
}

void
gdl_gview_reader_type_ploidy (gdl_gview_reader_type * type, size_t p)
{
	type->ploidy = p;	
}

void
gdl_gview_reader_type_locus_name (gdl_gview_reader_type * type, gdl_boolean has)
{
	type->has_loc_name = has;
}

void
gdl_gview_reader_type_accession_name (gdl_gview_reader_type * type, gdl_boolean has)
{
	type->has_acc_name = has;
}

void
gdl_gview_reader_type_is_phased (gdl_gview_reader_type * type, gdl_boolean is)
{
	type->is_phased = is;	
}

