/*  
 * 	gview/standard.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_fsheet.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_writer.h>

static int
_standard_write (FILE * stream, const gdl_gview * gview)
{
	size_t i, j, k;
	size_t nl = gdl_gview_locus_size (gview);
	size_t na = gdl_gview_accession_size (gview);
	gdl_gvalues_get * get;
	const gdl_gvalues * gv;
	
	for (j = 0; j < nl; j++)
	{
		gdl_locus * locus = gdl_gview_get_locus (gview, j);
		if (j) fprintf (stream, "\t");
		fprintf (stream, "%s", locus->name);
	}
	fprintf (stream, "\n");
	
	get = gdl_gview_get_new (gview);
	
	for (i = 0; i < na; i++)
	{
		gdl_accession * accession = gdl_gview_get_accession	(gview, i);
		fprintf (stream, "%s", accession->name);
		
		for (j = 0; j < nl; j++)
		{
			gdl_locus * locus = gdl_gview_get_locus (gview, j);
			
			fprintf (stream, "\t");
			
			gdl_gview_genotype_f (gview, i, j, get);
			
			gv = gdl_gvalues_get_gvalues (get);
			
			if (gv)
			{
				
				for (k = 0; k < gv->size; k++)
				{
					gdl_genotype * genotype = gdl_locus_get_genotype (locus, gv->values[k]->idx);
					if (gv->size > 1)
					{
						fprintf (stream, "%s:%g", gdl_entity_get_name (genotype), gv->values[k]->value);
					}
					else
					{
						fprintf (stream, "%s", gdl_entity_get_name (genotype));
					}
					if (k < gv->size - 1)
						fprintf (stream, ";");
				}
				
			}
			else
			{
				fprintf (stream, "?");
			}
		}
		
		fprintf (stream, "\n");
	}
	
	gdl_gvalues_get_free (get);
	
	return GDL_SUCCESS;
}

static int
_standard_write_wrapper (FILE * stream, const gdl_gview_wrapper * gview)
{
	size_t i, j, k;
	size_t nl = gdl_gview_wrapper_locus_size (gview);
	size_t na = gdl_gview_wrapper_accession_size (gview);
	gdl_gvalues_get * get;
	const gdl_gvalues * gv;
	
	for (j = 0; j < nl; j++)
	{
		gdl_locus * locus = gdl_gview_wrapper_get_locus (gview, j);
		if (j) fprintf (stream, "\t");
		fprintf (stream, "%s", locus->name);
	}
	fprintf (stream, "\n");
	
	get = gdl_gview_wrapper_get_new (gview);
	
	for (i = 0; i < na; i++)
	{
		gdl_accession * accession = gdl_gview_wrapper_get_accession	(gview, i);
		fprintf (stream, "%s", accession->name);
		
		for (j = 0; j < nl; j++)
		{
			gdl_locus * locus = gdl_gview_wrapper_get_locus (gview, j);
			
			fprintf (stream, "\t");
			
			gdl_gview_wrapper_get_genotype (gview, i, j, get);
			
			gv = gdl_gvalues_get_gvalues (get);
			
			if (gv)
			{
				size_t kk;
				for (kk = k = 0; k < gv->size; k++)
				{
					if (gv->size > 1 && gv->values[k]->value > 0.0)
						kk = k;
				}
				for (k = 0; k < gv->size; k++)
				{
					gdl_genotype * genotype = gdl_locus_get_genotype (locus, gv->values[k]->idx);
					if (gv->size > 1 && gv->values[k]->value > 0.0)
					{
						fprintf (stream, "%s:%1.5f", gdl_entity_get_name (genotype), gv->values[k]->value);
						if (k != kk) fprintf (stream, ";");
					}
					else if (gv->size==1)
					{
						fprintf (stream, "%s", gdl_entity_get_name (genotype));
					}
				}				
			}
			else
			{
				fprintf (stream, "?");
			}
		}
		
		fprintf (stream, "\n");
	}
	
	gdl_gvalues_get_free (get);
	
	return GDL_SUCCESS;
}

static gdl_gview_writer_type _gdl_gview_writer_standard = 
{
	"?",
	&_standard_write,
	&_standard_write_wrapper
};

const gdl_gview_writer_type * gdl_gview_writer_standard 
                                   = &_gdl_gview_writer_standard;
