/*  
 * 	gview/wtype.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_gview_writer.h>

gdl_gview_writer_type *
gdl_gview_writer_type_new (const gdl_gview_writer_type * type)
{
	if (type)
	{
		gdl_gview_writer_type * clone;
		
		clone = GDL_CALLOC (gdl_gview_writer_type, 1);
		
		clone->missing       = gdl_string_clone (type->missing);
		clone->write         = type->write;
		clone->write_wrapper = type->write_wrapper;
		
		return clone;
	}
}

void
gdl_gview_writer_type_free (gdl_gview_writer_type * type)
{
	if (type)
	{
		gdl_string_free (type->missing);		
		GDL_FREE (type);
	}
}

void
gdl_gview_writer_type_missing (gdl_gview_writer_type * type, gdl_string * missing)
{
	gdl_string_free (type->missing);
	type->missing = gdl_string_clone (missing);
}

//void
//gdl_gview_writer_type_nfsep (gdl_gview_writer_type * type, gdl_string * nfsep)
//{
//	gdl_string_free (type->nfsep);
//	type->nfsep = gdl_string_clone (nfsep);
//}
//
//void
//gdl_gview_writer_type_gfsep (gdl_gview_writer_type * type, gdl_string * gfsep)
//{
//	gdl_string_free (type->gfsep);
//	type->gfsep = gdl_string_clone (gfsep);	
//}
//
//void
//gdl_gview_writer_type_ploidy (gdl_gview_writer_type * type, size_t p)
//{
//	type->ploidy = p;	
//}
//
//void
//gdl_gview_writer_type_locus_name (gdl_gview_writer_type * type, gdl_boolean has)
//{
//	type->has_loc_name = has;
//}
//
//void
//gdl_gview_writer_type_is_phased (gdl_gview_writer_type * type, gdl_boolean is)
//{
//	type->is_phased = is;	
//}

