/*  
 * 	hash/gdl_hash.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:47 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_HASH_H__
#define __GDL_HASH_H__

#include <gdl/gdl_common.h>

__BEGIN_DECLS

typedef struct _gdl_hashtable gdl_hashtable;
typedef struct _gdl_hashtable_itr gdl_hashtable_itr;

gdl_hashtable * gdl_hashtable_alloc (const gdl_data_interface * type, size_t size);
void gdl_hashtable_free (gdl_hashtable * table);

size_t gdl_hashtable_add (gdl_hashtable * table, const char * name, void * value, size_t owner);
size_t gdl_hashtable_add_const (gdl_hashtable * table, const char * name, const void * value);
size_t gdl_hashtable_update (gdl_hashtable * table, const char * name, void * value, size_t owner);
void * gdl_hashtable_lookup (gdl_hashtable * table, const char * name);
void * gdl_hashtable_lookup2 (gdl_hashtable * table, const char * key, size_t * owner);
size_t gdl_hashtable_remove (gdl_hashtable * table, const char * name);

size_t gdl_hashtable_vadd (gdl_hashtable * table, const void * key, void * value, size_t owner);
size_t gdl_hashtable_vupdate (gdl_hashtable * table, const void * key, void * value, size_t owner);
void * gdl_hashtable_vlookup (gdl_hashtable * table, const void * key);
void * gdl_hashtable_vlookup2 (gdl_hashtable * table, const void * key, size_t * owner);
size_t gdl_hashtable_vremove (gdl_hashtable * table, const void * key);

gdl_hashtable * gdl_hashtable_clone (gdl_hashtable * table);

size_t gdl_hashtable_empty (gdl_hashtable * table);
size_t gdl_hashtable_size (gdl_hashtable * table);

int gdl_hashtable_fread (FILE * stream, gdl_hashtable * table);
int gdl_hashtable_fwrite (FILE * stream, gdl_hashtable * table);

gdl_hashtable_itr * gdl_hashtable_iterator (gdl_hashtable * h);
int gdl_hashtable_iterator_next (gdl_hashtable_itr * itr);
char * gdl_hashtable_iterator_key (gdl_hashtable_itr * itr);
void * gdl_hashtable_iterator_value (gdl_hashtable_itr * itr);
void gdl_hashtable_iterator_free (gdl_hashtable_itr * itr);

GDL_VAR const gdl_data_interface * gdl_hash_default;

__END_DECLS

#endif /* __GDL_HASH_H__ */
