/*  
 * 	hmap/gdl_hmap.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:45 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HMAP_H__
#define __GDL_HMAP_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_gmap.h>

__BEGIN_DECLS

typedef struct _gdl_hmap gdl_hmap;

gdl_hmap * gdl_hmap_alloc (const gdl_gview * g, const gdl_mask * m, const gdl_gmap * map);
int gdl_hmap_create (gdl_hmap * h);
void gdl_hmap_free (gdl_hmap * h);

int gdl_hmap_fread (FILE * stream, gdl_hmap * h);
int gdl_hmap_fwrite (FILE * stream, const gdl_hmap * h);

size_t gdl_hmap_size (const gdl_hmap * h);
const size_t * gdl_hmap_genome_sizes (const gdl_hmap * h);
size_t gdl_hmap_genome_size (const gdl_hmap * h, size_t genome);
size_t gdl_hmap_chromosome_size (const gdl_hmap * h, size_t genome, size_t chrom);
size_t gdl_hmap_accession_size (const gdl_hmap * h);
size_t gdl_hmap_locus_size (const gdl_hmap * h);

const gdl_mask * gdl_hmap_get_gmask (const gdl_hmap * h);
gdl_accession * gdl_hmap_get_accession (const gdl_hmap * h, size_t a);
gdl_locus * gdl_hmap_get_locus (const gdl_hmap * h, size_t l);
gdl_hview * gdl_hmap_get_hview (const gdl_hmap * h, size_t genome, size_t chrom);

const gdl_gview * gdl_hmap_get_gview (const gdl_hmap * h);
const gdl_mask * gdl_hmap_get_mask (const gdl_hmap * h);
const gdl_gmap * gdl_hmap_get_gmap (const gdl_hmap * h);


__END_DECLS

#endif /* __GDL_HMAP_H__ */
