/*  
 *  hsmap/gdl_hsmap.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSMAP_H__
#define __GDL_HSMAP_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_hmap.h>
#include <gdl/gdl_fview_wrapper.h>
#include <gdl/gdl_view.h>
#include <gdl/gdl_hstruct_model.h>
#include <gdl/gdl_hstruct_result.h>
#include <gdl/gdl_hsmap_partition.h>
#include <gdl/gdl_hsmap_params.h>
#include <gdl/gdl_hsmap_model.h>

__BEGIN_DECLS

typedef struct _gdl_hsmap_workspace gdl_hsmap_workspace;

gdl_hsmap_workspace * gdl_hsmap_workspace_alloc (const gdl_hstruct_result * result, const gdl_view * v, const gdl_rng * rng);
void gdl_hsmap_workspace_free (gdl_hsmap_workspace * w);
FILE * gdl_hsmap_workspace_set_logger (gdl_hsmap_workspace * w, FILE * stream);

int gdl_hsmap_workspace_perform (gdl_hsmap_workspace * w, const gdl_fview_wrapper * trait, const gdl_fview_wrapper * other, const gdl_hsmap_params * params);

__END_DECLS

#endif
