/*  
 *  hsmap/params.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_hsmap_params.h>

gdl_hsmap_params *
gdl_hsmap_params_default ()
{
	gdl_hsmap_params * p;
	
	p = GDL_CALLOC (gdl_hsmap_params, 1);
	
	p->mode    = gdl_hsmap_test;
	p->fbpout  = 0.05; 
	p->fbpin   = 0.05;
	p->fbiter  = 100;
	p->pheap   = 0.95;
	p->walk    = gdl_false;
	
	return p;
}

void
gdl_hsmap_params_free (gdl_hsmap_params * p)
{
	GDL_FREE (p);
}
