/*  
 * 	hstruct/data.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gpoint.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_hstruct_data.h>

gdl_hstruct_data *
gdl_hstruct_data_alloc (void)
{
	gdl_hstruct_data * d;
	
	d = GDL_CALLOC (gdl_hstruct_data, 1);

	return d;
}

void
gdl_hstruct_data_free (gdl_hstruct_data * d)
{
	if (d)
	{
		gdl_gmap_free (d->gmap);
		GDL_FREE (d);		
	}
}

void
gdl_hstruct_data_set_gview (gdl_hstruct_data * d, const gdl_gview * g)
{
	d->gview = g;
}

void
gdl_hstruct_data_set_gmask (gdl_hstruct_data * d, const gdl_mask * g)
{
	d->gmask = g;
}

void
gdl_hstruct_data_set_gclust (gdl_hstruct_data * d, const gdl_clustering * g)
{
	d->gclust = g;	
}

void
gdl_hstruct_data_set_chrom (gdl_hstruct_data * d, const gdl_chromosome * g)
{
	d->chrom = g;
}

const gdl_view *
gdl_hstruct_data_get_view (gdl_hstruct_data * d)
{
	return d->view;	
}

const gdl_gview *
gdl_hstruct_data_get_gview (gdl_hstruct_data * d)
{
	if (d->view)
	{
		d->gview = gdl_view_get_gview (d->view);
	}
	return d->gview;
}

const gdl_gmap *
gdl_hstruct_data_get_gmap (gdl_hstruct_data * d)
{
	if (d->gmap==0 && d->view)
	{
		d->gmap = gdl_view_extract_gmap_clone (d->view, d->gmask);
	}
	return d->gmap;
}

const gdl_mask *
gdl_hstruct_data_get_gmask (gdl_hstruct_data * d)
{
	return d->gmask;
}

const gdl_clustering *
gdl_hstruct_data_get_gclust (gdl_hstruct_data * d)
{
	return d->gclust;
}

const gdl_rng *
gdl_hstruct_data_get_rng (gdl_hstruct_data * d)
{
	return d->rng;	
}

size_t
gdl_hstruct_data_size (gdl_hstruct_data * d)
{
	const gdl_gview * g = gdl_hstruct_data_get_gview (d);
	size_t n = GDL_GVIEW_ACCESSION_SIZE (g, gdl_hstruct_data_get_gmask (d));
	return n*gdl_gview_ploidy (g);
}

void
gdl_hstruct_data_set_locus_type (gdl_hstruct_data * d, const gdl_locus_type_registry * locus_type)
{
	d->locus_type = locus_type;	
}

const gdl_locus_type_registry *
gdl_hstruct_data_get_locus_type (const gdl_hstruct_data * d)
{
	return d->locus_type;	
}
