/*  
 * 	hstruct/gdl_hstruct.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_H__
#define __GDL_HSTRUCT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gpartition.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_view.h>
#include <gdl/gdl_hmap.h>
#include <gdl/gdl_hstruct_fuzzy.h>
#include <gdl/gdl_hstruct_model.h>
#include <gdl/gdl_hstruct_criterion.h>

__BEGIN_DECLS

typedef struct _gdl_hstruct_workspace gdl_hstruct_workspace;
typedef struct _gdl_hstruct_hotspot_list gdl_hstruct_hotspot_list;

gdl_hstruct_workspace * gdl_hstruct_workspace_alloc (gdl_hstruct_model * M);
void gdl_hstruct_workspace_free (gdl_hstruct_workspace * w);

gdl_hstruct_workspace * gdl_hstruct_workspace_fread (FILE * stream);
int gdl_hstruct_workspace_fwrite (FILE * stream, const gdl_hstruct_workspace * w);

gdl_hstruct_model * gdl_hstruct_workspace_model (const gdl_hstruct_workspace * w );
size_t gdl_hstruct_workspace_chromosome_size (const gdl_hstruct_workspace * w);
size_t gdl_hstruct_workspace_partition_size (const gdl_hstruct_workspace * w, size_t c);

int gdl_hstruct_workspace_fuzzy_init (gdl_hstruct_workspace * w, size_t c, size_t p);
int gdl_hstruct_workspace_fuzzy_iterate (gdl_hstruct_workspace * w, size_t c, size_t p);
int gdl_hstruct_workspace_hmm_maximize (gdl_hstruct_workspace * w, double epsilon, size_t max_iter, gdl_boolean imputation);
int gdl_hstruct_workspace_hmm_iterate (gdl_hstruct_workspace * w);
int gdl_hstruct_workspace_hmm_iterate_point (gdl_hstruct_workspace * w, const gdl_hstruct_point_type * T, double * abs, double * sq);
int gdl_hstruct_workspace_hmm_imputation (gdl_hstruct_workspace * w);
int gdl_hstruct_workspace_hotrec_search (gdl_hstruct_workspace * w, const gdl_hstruct_criterion_type * C, size_t c, size_t p, gdl_hstruct_hotspot_list * hotspots);
int gdl_hstruct_workspace_hotrec_fast_search (gdl_hstruct_workspace * w, const gdl_hstruct_criterion_type * C, size_t c, size_t p, gdl_hstruct_hotspot_list * hotspots, const double q, const double f);
int gdl_hstruct_workspace_hotrec_check (gdl_hstruct_workspace * w, const gdl_hstruct_criterion_type * C, size_t c, size_t p, double tol, size_t max_iter, gdl_hstruct_hotspot_list * hotspots);
int gdl_hstruct_workspace_collapse_ancestral (gdl_hstruct_workspace * w, const gdl_hstruct_criterion_type * C, size_t c, size_t p, const double tol, const size_t max_iter, const size_t min_length);
int gdl_hstruct_workspace_ligation (gdl_hstruct_workspace * w, const gdl_gligation_type * T);

double gdl_hstruct_workspace_loglikelihood (const gdl_hstruct_workspace * w);
double gdl_hstruct_workspace_residual_sq (const gdl_hstruct_workspace * w);
double gdl_hstruct_workspace_residual_abs (const gdl_hstruct_workspace * w);
double gdl_hstruct_workspace_criterion (const gdl_hstruct_workspace * w, const gdl_hstruct_criterion_type * T);

const gdl_gvalues * gdl_hstruct_workspace_get_genotype (const gdl_hstruct_workspace * w, size_t a, size_t g, size_t c, size_t l, gdl_gvalues_get * gb);
const gdl_gvalues * gdl_hstruct_workspace_get_allele (const gdl_hstruct_workspace * w, size_t a, size_t g, size_t c, size_t l, size_t p, gdl_gvalues_get * gb);
double ** gdl_hstruct_workspace_accession_anc_pr (const gdl_hstruct_workspace * w, size_t a, size_t g, size_t c, size_t p);
size_t * gdl_hstruct_workspace_accession_anc_max_pr (const gdl_hstruct_workspace * w, size_t a, size_t g, size_t c, size_t p); 

FILE * gdl_hstruct_workspace_set_logger (gdl_hstruct_workspace * w, FILE * logger);

gdl_hstruct_hotspot_list * gdl_hstruct_hotspot_list_alloc (void);
void gdl_hstruct_hotspot_list_free (gdl_hstruct_hotspot_list * l);

size_t gdl_hstruct_hotspot_list_size (const gdl_hstruct_hotspot_list * l);
int gdl_hstruct_hotspot_list_compare (const gdl_hstruct_hotspot_list * l1, const gdl_hstruct_hotspot_list * l2);

__END_DECLS

#endif
