/*  
 * 	hstruct/gdl_hstruct_config.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_CONFIG_H__
#define __GDL_HSTRUCT_CONFIG_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_vector_uint.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_hstruct_point.h>

__BEGIN_DECLS

typedef struct
{
	size_t k;
	void  ** mu;
	void  ** rho;
	void  ** hot;
	void  ** f;
} gdl_hstruct_config;

typedef gdl_hstruct_config * gdl_hstruct_config_ptr;

gdl_hstruct_config * gdl_hstruct_config_alloc (size_t k);
gdl_hstruct_config * gdl_hstruct_config_default (size_t k);
void gdl_hstruct_config_free (gdl_hstruct_config * c);
gdl_hstruct_config * gdl_hstruct_config_clone (const gdl_hstruct_config * c);
gdl_hstruct_config * gdl_hstruct_config_get (const gdl_locus * locus);
void gdl_hstruct_config_attach (gdl_hstruct_config * conf, gdl_locus * locus);
gdl_hstruct_config * gdl_hstruct_config_detach (gdl_locus * locus);
void gdl_hstruct_config_set_point (gdl_hstruct_config * c, const gdl_hstruct_point_type * T, void ** point);
void * gdl_hstruct_config_get_point (const gdl_hstruct_config * c, const gdl_hstruct_point_type * T);
void ** gdl_hstruct_config_get_point_ptr (const gdl_hstruct_config * c, const gdl_hstruct_point_type * T);
void gdl_hstruct_config_set_point_eligible (gdl_hstruct_config * c, const gdl_hstruct_point_type * T, gdl_boolean e);
size_t gdl_hstruct_config_point_inuse (const gdl_hstruct_config * c, const gdl_hstruct_point_type * T);
gdl_boolean gdl_hstruct_config_compare (const gdl_hstruct_config * c1, const gdl_hstruct_config * c2);

typedef struct _gdl_hstruct_config_collector gdl_hstruct_config_collector;
typedef gdl_hashtable_itr gdl_hstruct_config_itr;

gdl_hstruct_config_collector * gdl_hstruct_config_collector_alloc (size_t size);
void gdl_hstruct_config_collector_free (gdl_hstruct_config_collector * c);
int gdl_hstruct_config_collector_detach (gdl_hstruct_config_collector * c, gdl_hstruct_config * cf);
int gdl_hstruct_config_collector_attach (gdl_hstruct_config_collector * c, gdl_hstruct_config * cf);
size_t gdl_hstruct_config_collector_size (const gdl_hstruct_config_collector * c, const gdl_hstruct_config * cf);
gdl_hstruct_config_itr * gdl_hstruct_config_collector_iterator (const gdl_hstruct_config_collector * c);
gdl_hstruct_config * gdl_hstruct_config_collector_iterator_config (gdl_hstruct_config_itr * itr);
gdl_boolean gdl_hstruct_config_collector_iterator_next (gdl_hstruct_config_itr * itr);
void gdl_hstruct_config_collector_iterator_free (gdl_hstruct_config_itr * itr);

typedef struct _gdl_hstruct_config_buffer gdl_hstruct_config_buffer;

gdl_hstruct_config_buffer * gdl_hstruct_config_buffer_alloc (const gdl_hstruct_config_collector * c);
void gdl_hstruct_config_buffer_realloc (gdl_hstruct_config_buffer * t);
void gdl_hstruct_config_buffer_free (gdl_hstruct_config_buffer * t);
int gdl_hstruct_config_buffer_set (gdl_hstruct_config_buffer * t, const gdl_hstruct_point_type * T, void ** p);
gdl_hstruct_config * gdl_hstruct_config_buffer_new (gdl_hstruct_config_buffer * t, const gdl_hstruct_config * old);
gdl_hstruct_config * gdl_hstruct_config_buffer_old (gdl_hstruct_config_buffer * t, const gdl_hstruct_config * new);

int gdl_hstruct_config_buffer_flush (gdl_hstruct_config_buffer * t, const gdl_hstruct_config * new);
int gdl_hstruct_config_buffer_unflush (gdl_hstruct_config_buffer * t, const gdl_hstruct_config * new);

typedef struct
{
	gdl_hstruct_config_collector  * collector;
	gdl_hstruct_config_buffer     * buffer;
	size_t k;
	size_t from;
	size_t to;
} gdl_hstruct_config_block;

gdl_hstruct_config_block * gdl_hstruct_config_block_alloc (gdl_hstruct_config_collector * collector, size_t from, size_t to);
void gdl_hstruct_config_block_free (gdl_hstruct_config_block * b);

size_t gdl_hstruct_config_block_ancestral_size (gdl_hstruct_config_block * b);
size_t gdl_hstruct_config_block_from (gdl_hstruct_config_block * b);
size_t gdl_hstruct_config_block_to (gdl_hstruct_config_block * b);
gdl_boolean gdl_hstruct_config_block_has_hotspot (gdl_hstruct_config_block * b);
gdl_hstruct_config_collector * gdl_hstruct_config_block_config_collector (gdl_hstruct_config_block * b);
gdl_hstruct_config_buffer * gdl_hstruct_config_block_buffer (gdl_hstruct_config_block * b);
void gdl_hstruct_config_block_set_point_eligible (gdl_hstruct_config_block * b, const gdl_hstruct_point_type * T, gdl_boolean eligible);

typedef struct
{
	size_t k;
	int rho_idx;
	int mu_idx;
	int hot_idx;
	int f_idx;
	gdl_allele    ** ancestral;
	gdl_hashtable ** mutation;
} gdl_hstruct_static_config;

gdl_hstruct_static_config * gdl_hstruct_static_config_alloc (size_t k);
void gdl_hstruct_static_config_free (gdl_hstruct_static_config * c);
gdl_hstruct_static_config * gdl_hstruct_static_config_clone (const gdl_hstruct_static_config * c);
gdl_hstruct_static_config * gdl_hstruct_static_config_extend (const gdl_hstruct_static_config * c, size_t k, size_t f_idx);
int gdl_hstruct_static_config_add_mutation (gdl_hstruct_static_config * c, size_t k, size_t allele);
gdl_vector_uint * gdl_hstruct_static_config_get_mutations (const gdl_hstruct_static_config * c, size_t k);

gdl_hstruct_static_config * gdl_hstruct_static_config_fread (FILE * stream);
int gdl_hstruct_static_config_fwrite (FILE * stream, const gdl_hstruct_static_config * c);

typedef struct
{
	gdl_boolean rho;
	gdl_boolean hot;
	gdl_boolean mu;
	gdl_boolean f;
	gdl_boolean k;
} gdl_hstruct_config_template;

int gdl_hstruct_config_template_compare (const gdl_hstruct_config_template * t, const gdl_hstruct_config * c1, const gdl_hstruct_config * c2);

__END_DECLS

#endif
