/*  
 * 	hstruct/gdl_hstruct_model_partition.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_MODEL_PARTITION_H__
#define __GDL_HSTRUCT_MODEL_PARTITION_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gpartition.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_gpartition.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_wrapper.h>
#include <gdl/gdl_hstruct_fuzzy.h>
#include <gdl/gdl_hstruct_hmm.h>
#include <gdl/gdl_hstruct_data.h>
#include <gdl/gdl_hstruct_point.h>
#include <gdl/gdl_hstruct_config.h>
#include <gdl/gdl_hstruct_parameters.h>
#include <gdl/gdl_hstruct_model_type.h>

__BEGIN_DECLS

typedef struct _gdl_hstruct_model_partition gdl_hstruct_model_partition;

gdl_hstruct_model_partition * gdl_hstruct_model_partition_alloc (const gdl_hstruct_data * d, const gdl_mask * gmask, size_t cidx, size_t pidx, size_t pos);
void gdl_hstruct_model_partition_free (gdl_hstruct_model_partition * p);
int gdl_hstruct_model_partition_init (gdl_hstruct_model_partition * p, size_t k);

const gdl_chromosome * gdl_hstruct_model_partition_chromosome (const gdl_hstruct_model_partition * p);
gdl_gview_wrapper * gdl_hstruct_model_partition_data (const gdl_hstruct_model_partition * p);

gdl_hstruct_fuzzy   * gdl_hstruct_model_partition_get_fuzzy (const gdl_hstruct_model_partition * p);
gdl_hstruct_hmm     * gdl_hstruct_model_partition_get_hmm (const gdl_hstruct_model_partition * p);
gdl_gview_wrapper   * gdl_hstruct_model_partition_get_wrapper (const gdl_hstruct_model_partition * p);

int gdl_hstruct_model_partition_fuzzy2hmm (gdl_hstruct_model_partition * p);

size_t gdl_hstruct_model_partition_get_cidx (const gdl_hstruct_model_partition * p);
size_t gdl_hstruct_model_partition_get_pidx (const gdl_hstruct_model_partition * p);
size_t gdl_hstruct_model_partition_size (const gdl_hstruct_model_partition * p);
size_t gdl_hstruct_model_partition_ancestral_size (const gdl_hstruct_model_partition * p);
size_t gdl_hstruct_model_partition_ligation_site (const gdl_hstruct_model_partition * p);
void gdl_hstruct_model_partition_reset_ligation_site (gdl_hstruct_model_partition * p);
size_t gdl_hstruct_model_partition_get_kmax (const gdl_hstruct_model_partition * p);

gdl_locus * gdl_hstruct_model_partition_get_locus (const gdl_hstruct_model_partition * p, size_t l);
const gdl_locus_type *  gdl_hstruct_model_partition_get_locus_type (const gdl_hstruct_model_partition * p, size_t l);
gdl_hstruct_config * gdl_hstruct_model_partition_get_config (const gdl_hstruct_model_partition * p, size_t l);
gdl_gdistance * gdl_hstruct_model_partition_get_distance (const gdl_hstruct_model_partition * p, size_t l);
void gdl_hstruct_model_partition_set_ancestral (gdl_hstruct_model_partition * p, size_t k, size_t l, size_t a);
size_t gdl_hstruct_model_partition_get_ancestral (const gdl_hstruct_model_partition * p, size_t k, size_t l);
void gdl_hstruct_model_partition_swap_ancestral (gdl_hstruct_model_partition * p, size_t k1, size_t k2, size_t l);
void gdl_hstruct_model_partition_permut_ancestral (gdl_hstruct_model_partition * p, size_t from, size_t to, size_t * permut, size_t k);

int gdl_hstruct_model_partition_attach_handler (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr, gdl_hstruct_point_handler * h);
int gdl_hstruct_model_partition_attach_config (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr, gdl_hstruct_config * c, size_t l);

gdl_hstruct_config_buffer * gdl_hstruct_model_partition_new_buffer (gdl_hstruct_model_partition * pm);
int gdl_hstruct_model_partition_update (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr, gdl_hstruct_config_buffer * t, size_t l);
int gdl_hstruct_model_partition_restore (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr, gdl_hstruct_config_buffer * t, size_t l);

double gdl_hstruct_model_partition_loglikelihood (const gdl_hstruct_model_partition * p);
double gdl_hstruct_model_partition_ancestral_freq (const gdl_hstruct_model_partition * p, size_t k, size_t from, size_t to);
gdl_vector * gdl_hstruct_model_partition_cumul_transition_proba (gdl_hstruct_model_partition * p);

gdl_hstruct_point_handler * gdl_hstruct_model_partition_collapse_ancestral_block (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr, gdl_hstruct_config_block * block, size_t k);
void gdl_hstruct_model_partition_restore_ancestral_block (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr, gdl_hstruct_config_block * block, size_t k);
gdl_hstruct_point_handler * gdl_hstruct_model_partition_collapse_ancestral_block2 (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr, gdl_hstruct_config_block * hot1, gdl_hstruct_config_block * block, gdl_hstruct_config_block * hot2, size_t k);
void gdl_hstruct_model_partition_restore_ancestral_block2 (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr, gdl_hstruct_config_block * hot1, gdl_hstruct_config_block * block, gdl_hstruct_config_block * hot2, size_t k);

gdl_hstruct_point_handler * gdl_hstruct_model_partition_remove_hotspot_block (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr, gdl_hstruct_config_block * block);
void gdl_hstruct_model_partition_restore_hotspot_block (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr, gdl_hstruct_config_block * block);

gdl_mask * gdl_hstruct_model_partition_ligation (gdl_hstruct_parameters * pr, gdl_hstruct_model_partition * p1, const gdl_hstruct_model_partition * p2, const gdl_gligation_type * T, void * extra);

int gdl_hstruct_model_partition_backup_points (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr);
int gdl_hstruct_model_partition_restore_points (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr);

void gdl_hstruct_model_partition_check_config_block (gdl_hstruct_model_partition * p, gdl_hstruct_parameters * pr);

typedef struct _gdl_hstruct_config_block_itr gdl_hstruct_config_block_itr;

gdl_hstruct_config_block_itr * gdl_hstruct_model_partition_config_block_iterator (gdl_hstruct_model_partition * p, const gdl_hstruct_config_template * template);
gdl_boolean gdl_hstruct_config_block_iterator_next (gdl_hstruct_config_block_itr * itr, gdl_boolean free);
gdl_hstruct_config_block * gdl_hstruct_config_block_iterator_get (gdl_hstruct_config_block_itr * itr);
void gdl_hstruct_config_block_iterator_free (gdl_hstruct_config_block_itr *);

__END_DECLS

#endif
