/*  
 * 	hstruct/gdl_hstruct_parameters.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_PARAMETERS_H__
#define __GDL_HSTRUCT_PARAMETERS_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_locus.h>
#include <gdl/gdl_hstruct_point.h>
#include <gdl/gdl_hstruct_config.h>

__BEGIN_DECLS

typedef struct _gdl_hstruct_parameter_domain gdl_hstruct_parameter_domain;
typedef struct _gdl_hstruct_parameter_collector gdl_hstruct_parameter_collector;
typedef struct _gdl_hstruct_parameters gdl_hstruct_parameters;
typedef struct _gdl_hashtable_itr gdl_hstruct_parameter_itr;
typedef struct _gdl_hstruct_static_parameters gdl_hstruct_static_parameters;
typedef struct _gdl_hstruct_static_parameter_registry gdl_hstruct_static_parameter_registry;

size_t gdl_hstruct_parameter_domain_size (const gdl_hstruct_parameter_domain * d);
size_t gdl_hstruct_parameter_domain_get_cidx (const gdl_hstruct_parameter_domain * d, size_t i);
size_t gdl_hstruct_parameter_domain_get_pidx (const gdl_hstruct_parameter_domain * d, size_t j);

gdl_hstruct_parameter_collector * gdl_hstruct_parameter_collector_alloc ();
void gdl_hstruct_parameter_collector_free (gdl_hstruct_parameter_collector * c);

gdl_hstruct_parameters * gdl_hstruct_parameters_alloc (size_t k);
void gdl_hstruct_parameters_free (gdl_hstruct_parameters * r);
gdl_hstruct_parameters * gdl_hstruct_parameters_clone (const gdl_hstruct_parameters * r);

size_t gdl_hstruct_parameters_size (const gdl_hstruct_parameters * r);

gdl_hstruct_config * gdl_hstruct_parameters_new_config (gdl_hstruct_parameters * r);
gdl_hstruct_config * gdl_hstruct_parameters_clone_config (gdl_hstruct_parameters * r, const gdl_hstruct_config * c);
const gdl_hstruct_config * gdl_hstruct_parameters_last_config (gdl_hstruct_parameters * r);
gdl_hstruct_point_handler * gdl_hstruct_parameters_new_handler (gdl_hstruct_parameters * r, const gdl_hstruct_point_type * T, void * extra);
void ** gdl_hstruct_parameters_new_point (gdl_hstruct_parameters * r, const gdl_hstruct_point_type * T, void * extra);
void * gdl_hstruct_parameters_get_point (const gdl_hstruct_parameters * r, const gdl_hstruct_point_type * T, size_t i);
int gdl_hstruct_parameters_get_point_index (const gdl_hstruct_parameters * r, const gdl_hstruct_point_type * T, void * p);

void gdl_hstruct_config_block_update (gdl_hstruct_parameters * p, gdl_hstruct_config_block * b);
void gdl_hstruct_parameters_clean_config (gdl_hstruct_parameters * r, gdl_hstruct_config * c);
void gdl_hstruct_parameters_clean_point (gdl_hstruct_parameters * r, const gdl_hstruct_point_type * T, void ** p);
void gdl_hstruct_parameters_clean_handler (gdl_hstruct_parameters * r, gdl_hstruct_point_handler * h);
int gdl_hstruct_parameters_attach_handler (gdl_hstruct_parameters * r, size_t c, size_t p, gdl_hstruct_point_handler * h);
int gdl_hstruct_parameters_detach_handler (gdl_hstruct_parameters * r, size_t c, size_t p, gdl_hstruct_point_handler * h);
gdl_hstruct_config * gdl_hstruct_parameters_attach_config (gdl_hstruct_parameters * r, size_t c, size_t p, gdl_hstruct_config * conf, gdl_locus * locus);
gdl_hstruct_config * gdl_hstruct_parameters_detach_config (gdl_hstruct_parameters * r, size_t c, size_t p, gdl_locus * locus);
int gdl_hstruct_parameters_update_config_domain (gdl_hstruct_parameters * r, gdl_hstruct_config * conf, size_t oc, size_t op, size_t c, size_t p);
gdl_hstruct_config * gdl_hstruct_parameters_setup_config (gdl_hstruct_parameters * r, const gdl_hstruct_static_config * sconf);

int gdl_hstruct_parameters_flush_buffer (gdl_hstruct_parameters * r, gdl_hstruct_config_buffer * t, gdl_hstruct_config * new);
int gdl_hstruct_parameters_unflush_buffer (gdl_hstruct_parameters * r, gdl_hstruct_config_buffer * t, gdl_hstruct_config * new);

int gdl_hstruct_parameters_backup_points (gdl_hstruct_parameters * r, const gdl_hstruct_config_collector * collector);
int gdl_hstruct_parameters_backup_config_points (gdl_hstruct_parameters * r, const gdl_hstruct_config * config);
int gdl_hstruct_parameters_restore_points (gdl_hstruct_parameters * r, const gdl_hstruct_config_collector * collector);
int gdl_hstruct_parameters_restore_config_points (gdl_hstruct_parameters * r, const gdl_hstruct_config * config);

const gdl_hstruct_parameter_domain * gdl_hstruct_parameters_get_domain (gdl_hstruct_parameters * r, const gdl_hstruct_point_type * T, void * p);
gdl_hstruct_point_array * gdl_hstruct_parameters_get_point_array (const gdl_hstruct_parameters * r, const gdl_hstruct_point_type * T);

gdl_hstruct_parameter_itr * gdl_hstruct_parameter_iterate (const gdl_hstruct_parameters * r, const gdl_hstruct_point_type * T);
gdl_boolean gdl_hstruct_parameter_iterate_next (gdl_hstruct_parameter_itr * itr);
void * gdl_hstruct_parameter_iterate_point (gdl_hstruct_parameter_itr * itr);
size_t gdl_hstruct_parameter_iterate_point_idx (gdl_hstruct_parameter_itr * itr);
void gdl_hstruct_parameter_iterate_free (gdl_hstruct_parameter_itr * itr);

gdl_hstruct_static_parameters * gdl_hstruct_static_parameters_alloc (const gdl_hstruct_parameters * r);
void gdl_hstruct_static_parameters_free (gdl_hstruct_static_parameters * rs);
gdl_hstruct_static_config * gdl_hstruct_static_parameters_new_config (const gdl_hstruct_static_parameters * rs, const gdl_hstruct_config * c);
const gdl_hstruct_static_parameter_registry * gdl_hstruct_static_parameters_get_registry (const gdl_hstruct_static_parameters * rs);
gdl_hstruct_static_parameter_registry * gdl_hstruct_static_parameters_detach_registry (gdl_hstruct_static_parameters * rs);

void gdl_hstruct_static_parameter_registry_free (gdl_hstruct_static_parameter_registry * r);
size_t gdl_hstruct_static_parameter_registry_size (const gdl_hstruct_static_parameter_registry * r, const gdl_hstruct_point_type * T);
void * gdl_hstruct_static_parameter_registry_get (const gdl_hstruct_static_parameter_registry * r, const gdl_hstruct_point_type * T, size_t i);
gdl_hstruct_static_parameter_registry * gdl_hstruct_static_parameter_registry_fread (FILE * stream);
int gdl_hstruct_static_parameter_registry_fwrite (FILE * stream, const gdl_hstruct_static_parameter_registry * rs);

gdl_hstruct_parameters * gdl_hstruct_parameters_setup (const gdl_hstruct_static_parameter_registry * reg);

__END_DECLS

#endif
