/*  
 * 	hstruct/gdl_hstruct_point.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_POINT_H__
#define __GDL_HSTRUCT_POINT_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_view.h>

__BEGIN_DECLS

typedef struct _gdl_hstruct_point gdl_hstruct_point;

gdl_hstruct_point * gdl_hstruct_point_alloc (double x, double min, double max, double (*prior)(double x));
void gdl_hstruct_point_free (gdl_hstruct_point * t);
void gdl_hstruct_point_vfree (void * t);
gdl_hstruct_point * gdl_hstruct_point_clone (const gdl_hstruct_point * t);
int gdl_hstruct_point_copy (gdl_hstruct_point * dest, const gdl_hstruct_point * src);

gdl_boolean gdl_hstruct_point_is_eligible (const gdl_hstruct_point * t);
void gdl_hstruct_point_set_eligible (gdl_hstruct_point * t, gdl_boolean e);
double gdl_hstruct_point_value (const gdl_hstruct_point * t);
double gdl_hstruct_point_rng_value (const gdl_hstruct_point * t, const gdl_rng * rng);
double gdl_hstruct_point_update (gdl_hstruct_point * t, double x);
double gdl_hstruct_point_update_scale (gdl_hstruct_point * t, double x);
double gdl_hstruct_point_scale (gdl_hstruct_point * t, double x);
double gdl_hstruct_point_prior (const gdl_hstruct_point * t);
void gdl_hstruct_point_attach (gdl_hstruct_point * t);
void gdl_hstruct_point_detach (gdl_hstruct_point * t);
size_t gdl_hstruct_point_inuse (const gdl_hstruct_point * t);
void gdl_hstruct_point_set_golden_tolerance (gdl_hstruct_point * t, double tol);
double gdl_hstruct_point_get_golden_tolerance (const gdl_hstruct_point * t);

void gdl_hstruct_point_collect (gdl_hstruct_point * t, double x);
double gdl_hstruct_point_prior (const gdl_hstruct_point * t);

gdl_hstruct_point * gdl_hstruct_point_fread (FILE * stream);
gdl_hstruct_point * gdl_hstruct_point_sscanf (const gdl_string * str);
int gdl_hstruct_point_fwrite (FILE * stream, const gdl_hstruct_point * p);

double gdl_hstruct_point_hot_prior (double x);
double gdl_hstruct_point_mut_prior (double x);

typedef struct _gdl_hstruct_fpoint gdl_hstruct_fpoint;

gdl_hstruct_fpoint * gdl_hstruct_fpoint_alloc (size_t k);
void gdl_hstruct_fpoint_free (gdl_hstruct_fpoint * t);
void gdl_hstruct_fpoint_vfree (void * t);
gdl_hstruct_fpoint * gdl_hstruct_fpoint_clone (const gdl_hstruct_fpoint * t);
int gdl_hstruct_fpoint_copy (gdl_hstruct_fpoint * dest, const gdl_hstruct_fpoint * src);

gdl_boolean gdl_hstruct_fpoint_is_eligible (const gdl_hstruct_fpoint * t);
void gdl_hstruct_fpoint_set_eligible (gdl_hstruct_fpoint * t, gdl_boolean e);
size_t gdl_hstruct_fpoint_size (const gdl_hstruct_fpoint * t);
double gdl_hstruct_fpoint_value (const gdl_hstruct_fpoint * t, size_t k);
void gdl_hstruct_fpoint_init_collect (gdl_hstruct_fpoint * t);
void gdl_hstruct_fpoint_collect (gdl_hstruct_fpoint * t, size_t k, double x);
void gdl_hstruct_fpoint_update (gdl_hstruct_fpoint * t, double * abs, double * err);
void gdl_hstruct_fpoint_attach (gdl_hstruct_fpoint * t);
void gdl_hstruct_fpoint_detach (gdl_hstruct_fpoint * t);
size_t gdl_hstruct_fpoint_inuse (const gdl_hstruct_fpoint * t);
void gdl_hstruct_fpoint_swap (gdl_hstruct_fpoint * t, size_t k1, size_t k2);

gdl_hstruct_fpoint * gdl_hstruct_fpoint_fread (FILE * stream);
gdl_hstruct_fpoint * gdl_hstruct_fpoint_sscanf (const gdl_string * str);
int gdl_hstruct_fpoint_fwrite (FILE * stream, const gdl_hstruct_fpoint * p);

typedef struct
{
	gdl_string * name;
	void (*free) (void * point);
	void * (*clone) (const void * point);
	int (*copy) (void * dest, const void * src);
	void * (*fread) (FILE * stream);
	int (*fwrite) (FILE * stream, const void * point);
} gdl_hstruct_point_type;

const gdl_hstruct_point_type * gdl_hstruct_point_type_fread (FILE * stream);
int gdl_hstruct_point_type_fwrite (FILE * stream, const gdl_hstruct_point_type * T);

typedef struct
{
	const gdl_hstruct_point_type * type;
	size_t  size;
	void ** points;
} gdl_hstruct_point_array;

GDL_VAR const gdl_data_interface * gdl_hstruct_point_array_interface;

GDL_VAR const gdl_hstruct_point_type * gdl_hstruct_point_rho;
GDL_VAR const gdl_hstruct_point_type * gdl_hstruct_point_hot;
GDL_VAR const gdl_hstruct_point_type * gdl_hstruct_point_mu;
GDL_VAR const gdl_hstruct_point_type * gdl_hstruct_point_f;

typedef struct _gdl_hstruct_point_handler gdl_hstruct_point_handler;

gdl_hstruct_point_handler * gdl_hstruct_point_handler_alloc (const gdl_hstruct_point_type * T, void ** p);
void gdl_hstruct_point_handler_free (gdl_hstruct_point_handler * h);
const gdl_hstruct_point_type * gdl_hstruct_point_handler_type (gdl_hstruct_point_handler * h);
void * gdl_hstruct_point_handler_point (gdl_hstruct_point_handler * h);
void ** gdl_hstruct_point_handler_point_ptr (gdl_hstruct_point_handler * h);

gdl_hstruct_point_array * gdl_hstruct_point_array_alloc (const gdl_hstruct_point_type * T, size_t size);
void gdl_hstruct_point_array_free (gdl_hstruct_point_array * a);
size_t gdl_hstruct_point_array_size (gdl_hstruct_point_array * a);
void *  gdl_hstruct_point_array_get (gdl_hstruct_point_array * a, size_t i);
void gdl_hstruct_point_array_set (gdl_hstruct_point_array * a, size_t i, void * point);

__END_DECLS

#endif
