/*  
 *  hstruct/gdl_hstruct_rng_model.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_HSTRUCT_RNG_MODEL_H__
#define __GDL_HSTRUCT_RNG_MODEL_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_hstruct_point.h>

__BEGIN_DECLS

typedef struct _gdl_hstruct_rng_model gdl_hstruct_rng_model;

gdl_hstruct_rng_model * gdl_hstruct_rng_model_alloc (const gdl_gmap * map, size_t k);
void gdl_hstruct_rng_model_free (gdl_hstruct_rng_model * m);

gdl_hstruct_rng_model * gdl_hstruct_rng_model_fscanf (FILE * stream);
int gdl_hstruct_rng_model_fprintf (FILE * stream, const gdl_hstruct_rng_model * m);

size_t gdl_hstruct_rng_model_locus_size (const gdl_hstruct_rng_model * m);
const gdl_locus * gdl_hstruct_rng_model_get_locus (const gdl_hstruct_rng_model * m, size_t l);
const gdl_allele * gdl_hstruct_rng_model_get_allele (const gdl_hstruct_rng_model * m, size_t locus, size_t allele);
gdl_gmap * gdl_hstruct_rng_model_map (const gdl_hstruct_rng_model * m);

size_t gdl_hstruct_rng_model_add_parameter (gdl_hstruct_rng_model * m, const gdl_hstruct_point_type * T, void * value);
int gdl_hstruct_rng_model_set_locus_point (gdl_hstruct_rng_model * m, const gdl_locus * locus, const gdl_hstruct_point_type * T, size_t idx);
void gdl_hstruct_rng_model_set_locus_ancestral (gdl_hstruct_rng_model * m, const gdl_locus * locus, size_t k, size_t a);

gdl_vector_uint * gdl_hstruct_rng_model_generate (const gdl_hstruct_rng_model * m, const gdl_rng * rng);

__END_DECLS

#endif
