/*  
 * 	hstruct/handler.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_hstruct_point.h>

struct _gdl_hstruct_point_handler
{
	const gdl_hstruct_point_type *  type;
	gdl_list                     *  loci;
	gdl_hashtable                *  table;
	void                         ** point;
};

gdl_hstruct_point_handler *
gdl_hstruct_point_handler_alloc (const gdl_hstruct_point_type * T, void ** p)
{
	gdl_hstruct_point_handler * h;
	
	h = GDL_CALLOC (gdl_hstruct_point_handler, 1);
	
	h->type  = T;
	h->point = p;
	
	return h;	
}

void
gdl_hstruct_point_handler_free (gdl_hstruct_point_handler * h)
{
	if (h)
	{
		gdl_hashtable_free (h->table);
		gdl_list_free (h->loci);
		
		GDL_FREE (h);
	}	
}

const gdl_hstruct_point_type *
gdl_hstruct_point_handler_type (gdl_hstruct_point_handler * h)
{
	return h->type;	
}

void *
gdl_hstruct_point_handler_point (gdl_hstruct_point_handler * h)
{
	if (h->point)
	{
		return *(h->point);
	}
	else
	{
		return NULL;	
	}
}

void **
gdl_hstruct_point_handler_point_ptr (gdl_hstruct_point_handler * h)
{
	return h->point;
}

