/*  
 * 	hstruct/hotspots.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_hstruct.h>

struct _gdl_hstruct_hotspot
{
	size_t from;
	size_t to;
};

struct _gdl_hstruct_hotspot_list
{
	gdl_hashtable * hotspots;
};

gdl_hstruct_hotspot_list *
gdl_hstruct_hotspot_list_alloc (void)
{
	gdl_hstruct_hotspot_list * l;
	
	l = GDL_MALLOC (gdl_hstruct_hotspot_list, 1);
	
	l->hotspots = gdl_hashtable_alloc (gdl_hash_default, 0);
	
	return l;	
}

void
gdl_hstruct_hotspot_list_free (gdl_hstruct_hotspot_list * l)
{
	if (l)
	{
		if (gdl_hashtable_size (l->hotspots))
		{
			gdl_hashtable_itr * itr;
			
			itr = gdl_hashtable_iterator (l->hotspots);
			
			do
			{
				gdl_list * l = (gdl_list *) gdl_hashtable_iterator_value (itr);
				gdl_list_free (l);
			}
			while (gdl_hashtable_iterator_next (itr));
			
			gdl_hashtable_iterator_free (itr);
			
		}
		
		gdl_hashtable_free (l->hotspots);
		GDL_FREE (l);		
	}	
}

void
gdl_hstruct_hotspot_list_add (gdl_hstruct_hotspot_list * l, const gdl_hstruct_model_partition  * p, size_t from, size_t to)
{
	gdl_list * list;
	struct _gdl_hstruct_hotspot * h = GDL_MALLOC (struct _gdl_hstruct_hotspot, 1);
	
	h->from = from;
	h->to   = to;
	
	list = (gdl_list *) gdl_hashtable_vlookup (l->hotspots, p);
	if (!list)
	{
		list = gdl_list_alloc (gdl_list_default);
		gdl_hashtable_vadd (l->hotspots, p, list, 0);
	}
	gdl_list_push_back (list, h, 1);
}

size_t
gdl_hstruct_hotspot_list_size (const gdl_hstruct_hotspot_list * l)
{
	return gdl_hashtable_size (l->hotspots);	
}

int
gdl_hstruct_hotspot_list_compare (const gdl_hstruct_hotspot_list * l1, const gdl_hstruct_hotspot_list * l2)
{
	if (gdl_hashtable_size (l1->hotspots)
	    != gdl_hashtable_size (l2->hotspots))
	{
		return -1;	
	}
	if (gdl_hashtable_size (l1->hotspots)
	    && gdl_hashtable_size (l2->hotspots))
	{
		gdl_hashtable_itr * itr1, * itr2;
		
		itr1 = gdl_hashtable_iterator (l1->hotspots);
		
		do
		{
			size_t i, j;
			gdl_string * key = gdl_hashtable_iterator_key (itr1);
			gdl_list * list1 = (gdl_list *) gdl_hashtable_iterator_value (itr1);
			gdl_list * list2 = (gdl_list *) gdl_hashtable_lookup (l2->hotspots, key);
			if (list2 == 0 || gdl_list_size (list2) != gdl_list_size (list1))
			{
				gdl_hashtable_iterator_free (itr1);
				return -1;
			}
			for (i = 0; i < gdl_list_size (list1); i++)
			{
				struct _gdl_hstruct_hotspot * h1 = (struct _gdl_hstruct_hotspot *) gdl_list_get (list1, i);
				for (j = 0; j < gdl_list_size (list2); j++)
				{
					struct _gdl_hstruct_hotspot * h2 = (struct _gdl_hstruct_hotspot *) gdl_list_get (list2, j);
					if (h1->from == h2->from && h1->to == h2->to)
					{
						break;	
					}
				}
				if (j == gdl_list_size (list2))
				{
					gdl_hashtable_iterator_free (itr1);
					return -1;	
				}
			}
		}
		while (gdl_hashtable_iterator_next (itr1));
		
		gdl_hashtable_iterator_free (itr1);
		
		return 0;
	}
	
	return -1;
}
