/*  
 * 	hstruct/ptype.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:44 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hstruct_point.h>

const gdl_hstruct_point_type *
gdl_hstruct_point_type_fread (FILE * stream)
{
	const gdl_hstruct_point_type * T;
	
	gdl_string * name = gdl_string_fread (stream);
	GDL_FREAD_STATUS (name!=0, 1);
	
	if (!strcmp (name, gdl_hstruct_point_rho->name))
	{
		T = gdl_hstruct_point_rho;
	}
	else if (!strcmp (name, gdl_hstruct_point_hot->name))
	{
		T = gdl_hstruct_point_hot;
	}
	else if (!strcmp (name, gdl_hstruct_point_mu->name))
	{
		T = gdl_hstruct_point_mu;	
	}
	else if (!strcmp (name, gdl_hstruct_point_f->name))
	{
		T = gdl_hstruct_point_f;	
	}
	else
	{
		T = NULL;	
	}
	
	gdl_string_free (name);
	
	return T;
}

int
gdl_hstruct_point_type_fwrite (FILE * stream, const gdl_hstruct_point_type * T)
{
	if (stream && T)
	{
		int status;
		
		status = gdl_string_fwrite (stream, T->name);
		GDL_FWRITE_STATUS (status, GDL_SUCCESS);
		
		return GDL_SUCCESS;
	}
	
	return GDL_EINVAL;	
}

static void
_free_point (void * p)
{
	gdl_hstruct_point_free ((gdl_hstruct_point *)p);
}

static void *
_clone_point (const void * p)
{
	return gdl_hstruct_point_clone ((gdl_hstruct_point *)p);
}

static int
_copy_point (void * dest, const void * src)
{
	return gdl_hstruct_point_copy ((gdl_hstruct_point *)dest, (gdl_hstruct_point *)src);
}

static void *
_fread_point (FILE * stream)
{
	return gdl_hstruct_point_fread (stream);
}

static int
_fwrite_point (FILE * stream, const void * point)
{
	return gdl_hstruct_point_fwrite (stream, (gdl_hstruct_point *) point);	
}

static void
_free_fpoint (void * p)
{
	gdl_hstruct_fpoint_free ((gdl_hstruct_fpoint *)p);
}

static void *
_clone_fpoint (const void * p)
{
	return gdl_hstruct_fpoint_clone ((gdl_hstruct_fpoint *)p);
}

static int
_copy_fpoint (void * dest, const void * src)
{
	return gdl_hstruct_fpoint_copy ((gdl_hstruct_fpoint *)dest, (gdl_hstruct_fpoint *)src);
}

static void *
_fread_fpoint (FILE * stream)
{
	return gdl_hstruct_fpoint_fread (stream);	
}

static int
_fwrite_fpoint (FILE * stream, const void * point)
{
	return gdl_hstruct_fpoint_fwrite (stream, (gdl_hstruct_fpoint *) point);	
}

static const gdl_hstruct_point_type _rho =
{
	"gdl_hstruct_point_rho",
	&_free_point,
	&_clone_point,
	&_copy_point,
	&_fread_point,
	&_fwrite_point
};

static const gdl_hstruct_point_type _hot =
{
	"gdl_hstruct_point_hot",
	&_free_point,
	&_clone_point,
	&_copy_point,
	&_fread_point,
	&_fwrite_point
};

static const gdl_hstruct_point_type _mu =
{
	"gdl_hstruct_point_mu",
	&_free_point,
	&_clone_point,
	&_copy_point,
	&_fread_point,
	&_fwrite_point
};

static const gdl_hstruct_point_type _f =
{
	"gdl_hstruct_point_f",
	&_free_fpoint,
	&_clone_fpoint,
	&_copy_fpoint,
	&_fread_fpoint,
	&_fwrite_fpoint
};

const gdl_hstruct_point_type * gdl_hstruct_point_rho = &_rho;
const gdl_hstruct_point_type * gdl_hstruct_point_hot = &_hot;
const gdl_hstruct_point_type * gdl_hstruct_point_mu  = &_mu;
const gdl_hstruct_point_type * gdl_hstruct_point_f   = &_f;
