/**  
 * 	hview/hcrm.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:43 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_hash.h>
#include <gdl/gdl_list.h>
#include <gdl/gdl_sort.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_hview.h>

int
gdl_hview_hconfig_remove (gdl_hview * h, double pmin)
{
	size_t i, j, k, nhc;
	double s;
	
	for (i = 0; i < h->na; i++)
	{
		if (h->nhc[i] > 1)
		{
			nhc = h->nhc[i];
			for (s = j = 0; j < h->nhc[i];)
			{
				if (h->hconfigs[i][j]->pr <= pmin)
				{
					gdl_hconfig_free (h->hconfigs[i][j]);
					for (k = j; k < h->nhc[i] - 1; k++)
					{
						h->hconfigs[i][k] = h->hconfigs[i][k+1];
					}
					h->nhc[i] = h->nhc[i] - 1;
					if (h->nhc[i] == 1)
					{
						s = h->hconfigs[i][j]->pr;
						break;
					}
				}
				else
				{
					s += h->hconfigs[i][j]->pr;
					j++;
				}
			}
			if (nhc < h->nhc[i])
			{
				for (j = 0; j < h->nhc[i]; j++)
				{
					h->hconfigs[i][j]->pr /= s;
				}
			}
		}
	}
	
	return GDL_SUCCESS;
}
