/*  
 *  labels/gdl_flabels.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:54 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FLABELS_H__
#define __GDL_FLABELS_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_fview.h>
#include <gdl/gdl_fview_wrapper.h>

__BEGIN_DECLS

typedef struct _gdl_flabels gdl_flabels;

gdl_flabels * gdl_flabels_alloc (const gdl_fview * gview, const gdl_mask * mask, gdl_boolean last_level);
gdl_flabels * gdl_flabels_wrapper_alloc (const gdl_fview_wrapper * gwrap, gdl_boolean last_level);
gdl_flabels * gdl_flabels_wrapper_mask_alloc (const gdl_fview_wrapper * gwrap, const gdl_mask * mask, gdl_boolean last_level);

void gdl_flabels_free (gdl_flabels * gl);

size_t gdl_flabels_accession_size (const gdl_flabels * gl);
size_t gdl_flabels_factor_size (const gdl_flabels * gl);
size_t gdl_flabels_factor_level_size (const gdl_flabels * gl, size_t l);

gdl_string * gdl_flabels_accession (const gdl_flabels * gl, size_t a);
gdl_string * gdl_flabels_factor (const gdl_flabels * gl, size_t l);
gdl_string * gdl_flabels_level (const gdl_flabels * gl, size_t l, size_t a);

int gdl_flabels_level_cumul_index (const gdl_flabels * gl, size_t a, size_t * lidx, size_t * aidx);

int gdl_flabels_search_accession (const gdl_flabels * gl, const gdl_string * name);
int gdl_flabels_search_factor (const gdl_flabels * gl, const gdl_string * name);
int gdl_flabels_search_level (const gdl_flabels * gl, size_t factor, const gdl_string * name);

gdl_flabels * gdl_flabels_fread (FILE * stream);
int gdl_flabels_fwrite (FILE * stream, const gdl_flabels * gl);

__END_DECLS

#endif
