/*  
 * 	list/factory.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:45 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_list.h>

int
gdl_list_fread (FILE * stream, gdl_list * l)
{
	size_t i, size, status;
	
	if (stream == NULL || l == NULL)
		return GDL_EINVAL;
	
	if (!gdl_list_empty(l))
		gdl_list_clear (l);
		
	status = fread (&size, sizeof (size_t), 1, stream);
	GDL_FREAD_STATUS (status, 1);
	
	if (l->type->fread != NULL)
	{
		for (i = 0; i < size; i++)
		{
			void * data = (l->type->fread)(stream);
			GDL_FREAD_STATUS (data != 0, 1);
			gdl_list_push_front (l, data, 1);
		}
	}
	
	return GDL_SUCCESS;	
}

int
gdl_list_fwrite (FILE * stream, gdl_list * l)
{
	size_t i, status;
	
	if (stream == NULL || l == NULL)
		return GDL_EINVAL;
		
	status = fwrite (&l->size, sizeof (size_t), 1, stream);
	GDL_FWRITE_STATUS (status, 1);
	
	if (l->type->fwrite != NULL)
	{
		void * data;
		gdl_list_itr * itr = gdl_list_iterator_back (l);
		
		do
		{
			
			data = gdl_list_iterator_value (itr);
			status = (l->type->fwrite)(stream, data);
			GDL_FWRITE_STATUS (status, GDL_SUCCESS);
				
		} while (gdl_list_iterator_next (itr));
		
		gdl_list_iterator_free (itr);
	}
	
	return GDL_SUCCESS;
}
