/*  
 * 	list/gdl_list.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:45 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#ifndef __GDL_LIST_H__
#define __GDL_LIST_H__

#include <gdl/gdl_common.h>

__BEGIN_DECLS

typedef struct _gdl_link gdl_link;
typedef struct _gdl_list gdl_list;
typedef struct _gdl_list_itr gdl_list_itr;

gdl_list * gdl_list_alloc (const gdl_data_interface * t);
void gdl_list_free (gdl_list * l);
void * gdl_list_search  (gdl_list * l, void * data);
void * gdl_list_rsearch	(gdl_list * l, void * data);
int gdl_list_insert	(gdl_list * l, void * data, size_t owner);
int gdl_list_append	(gdl_list * l, void * data, size_t owner);
int	gdl_list_remove_first (gdl_list * l, void * data);
int gdl_list_remove_last (gdl_list * l, void * data);
int gdl_list_remove_all (gdl_list * l, void * data);
void gdl_list_clear	(gdl_list * l);
int gdl_list_empty (const gdl_list * l);
void * gdl_list_get (gdl_list * l, size_t i);
gdl_link * gdl_list_front (gdl_list * l);
gdl_link * gdl_list_end (gdl_list * l);
size_t gdl_list_size (gdl_list * l);
int gdl_list_push_front (gdl_list * l, void * data, size_t owner);
void * gdl_list_shift_front (gdl_list * l);
int gdl_list_push_back (gdl_list * l, void * data, size_t owner);
void * gdl_list_shift_back (gdl_list * l);
void gdl_list_reverse (gdl_list * l);
void gdl_list_sort (gdl_list * l);
void gdl_list_apply (gdl_list * l, gdl_data_apply apply,  const void * user);
void gdl_list_rapply (gdl_list * l, gdl_data_apply apply, const void *user);
void gdl_list_merge	(gdl_list * l1, gdl_list * l2);
gdl_list * 	gdl_list_clone (const gdl_list * old);
int	gdl_list_copy (gdl_list * cur, const gdl_list * old);
void * gdl_link_get (gdl_link * lk);

int gdl_list_fread (FILE * stream, gdl_list * l);
int gdl_list_fwrite (FILE * stream, gdl_list * l);

gdl_list_itr * gdl_list_iterator_front (const gdl_list * h);
gdl_list_itr * gdl_list_iterator_back (const gdl_list * h);
int gdl_list_iterator_next (gdl_list_itr * itr);
void * gdl_list_iterator_value (gdl_list_itr * itr);
void gdl_list_iterator_free (gdl_list_itr * itr);

GDL_VAR const gdl_data_interface * gdl_list_default;

__END_DECLS

#endif /* __GDL_LIST_H__ */

