/*  
 * 	list/iterator.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:45 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_list.h>

struct _gdl_list_itr
{
    const gdl_list * l;
    gdl_link * e;
    gdl_link * parent;
    size_t front;
};

gdl_list_itr *
gdl_list_iterator_alloc (const gdl_list * l)
{
	gdl_list_itr * itr = GDL_MALLOC (gdl_list_itr, 1);
    
    if (itr == NULL)
    {
    	GDL_ERROR_VAL ("Failed to create a gdl_list_iterator",
    	               GDL_ENOMEM,
    	               0);
    }
    
    itr->l      = l;
    itr->e      = NULL;
    itr->parent = NULL;
    
    if (gdl_list_empty (l))
    {
	    itr->parent = itr->e = itr->l->state;
    }
        
    return itr;	
}

void
gdl_list_iterator_free (gdl_list_itr * itr)
{
	itr->l = NULL;
	itr->e = NULL;
	itr->parent = NULL;
	GDL_FREE (itr);
}

gdl_list_itr *
gdl_list_iterator_front (const gdl_list * l)
{
	gdl_list_itr * itr = gdl_list_iterator_alloc (l);
	itr->front = 1;
	if (itr->e == NULL)
		itr->e = itr->l->state->next;
	return itr;
}

gdl_list_itr *
gdl_list_iterator_back (const gdl_list * l)
{
	gdl_list_itr * itr = gdl_list_iterator_alloc (l);
	itr->front = 0;
	if (itr->e == NULL)
		itr->e = itr->l->state->prev;
	return itr;
}

void *
gdl_list_iterator_value (gdl_list_itr * i)
{
    return i->e->data;
}

int
gdl_list_iterator_next (gdl_list_itr * itr)
{
	gdl_link * next;
	
    if (itr->e == itr->l->state)
    	return 0;
    
    if (itr->front)
	    next = itr->e->next;
	else
		next = itr->e->prev;
	
	if (next == itr->l->state)
    	return 0;
    
    if (next != NULL)
    {
        itr->parent = itr->e;
        itr->e      = next;
        return 1;
    }
}
